/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.autoscaling.model.Ebs;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BlockDeviceMapping
implements ToCopyableBuilder<Builder, BlockDeviceMapping> {
    private final String virtualName;
    private final String deviceName;
    private final Ebs ebs;
    private final Boolean noDevice;

    private BlockDeviceMapping(BuilderImpl builder) {
        this.virtualName = builder.virtualName;
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
    }

    public String virtualName() {
        return this.virtualName;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public Ebs ebs() {
        return this.ebs;
    }

    public Boolean noDevice() {
        return this.noDevice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebs());
        hashCode = 31 * hashCode + Objects.hashCode(this.noDevice());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockDeviceMapping)) {
            return false;
        }
        BlockDeviceMapping other = (BlockDeviceMapping)obj;
        return Objects.equals(this.virtualName(), other.virtualName()) && Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.ebs(), other.ebs()) && Objects.equals(this.noDevice(), other.noDevice());
    }

    public String toString() {
        return ToString.builder((String)"BlockDeviceMapping").add("VirtualName", (Object)this.virtualName()).add("DeviceName", (Object)this.deviceName()).add("Ebs", (Object)this.ebs()).add("NoDevice", (Object)this.noDevice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VirtualName": {
                return Optional.of(clazz.cast(this.virtualName()));
            }
            case "DeviceName": {
                return Optional.of(clazz.cast(this.deviceName()));
            }
            case "Ebs": {
                return Optional.of(clazz.cast(this.ebs()));
            }
            case "NoDevice": {
                return Optional.of(clazz.cast(this.noDevice()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String virtualName;
        private String deviceName;
        private Ebs ebs;
        private Boolean noDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockDeviceMapping model) {
            this.virtualName(model.virtualName);
            this.deviceName(model.deviceName);
            this.ebs(model.ebs);
            this.noDevice(model.noDevice);
        }

        public final String getVirtualName() {
            return this.virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final Ebs.Builder getEbs() {
            return this.ebs != null ? this.ebs.toBuilder() : null;
        }

        @Override
        public final Builder ebs(Ebs ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(Ebs.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        public final Boolean getNoDevice() {
            return this.noDevice;
        }

        @Override
        public final Builder noDevice(Boolean noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(Boolean noDevice) {
            this.noDevice = noDevice;
        }

        public BlockDeviceMapping build() {
            return new BlockDeviceMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BlockDeviceMapping> {
        public Builder virtualName(String var1);

        public Builder deviceName(String var1);

        public Builder ebs(Ebs var1);

        default public Builder ebs(Consumer<Ebs.Builder> ebs) {
            return this.ebs((Ebs)((Ebs.Builder)Ebs.builder().apply(ebs)).build());
        }

        public Builder noDevice(Boolean var1);
    }
}

