/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.autoscaling.model.SuspendedProcess;

public class SuspendedProcessUnmarshaller
implements Unmarshaller<SuspendedProcess, StaxUnmarshallerContext> {
    private static SuspendedProcessUnmarshaller INSTANCE;

    public SuspendedProcess unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SuspendedProcess.Builder suspendedProcess = SuspendedProcess.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ProcessName", targetDepth)) {
                    suspendedProcess.processName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SuspensionReason", targetDepth)) continue;
                suspendedProcess.suspensionReason(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SuspendedProcess)suspendedProcess.build();
    }

    public static SuspendedProcessUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SuspendedProcessUnmarshaller();
        }
        return INSTANCE;
    }
}

