/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.autoscaling.model.Ebs;

public class EbsUnmarshaller
implements Unmarshaller<Ebs, StaxUnmarshallerContext> {
    private static EbsUnmarshaller INSTANCE;

    public Ebs unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Ebs.Builder ebs = Ebs.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SnapshotId", targetDepth)) {
                    ebs.snapshotId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VolumeSize", targetDepth)) {
                    ebs.volumeSize(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VolumeType", targetDepth)) {
                    ebs.volumeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DeleteOnTermination", targetDepth)) {
                    ebs.deleteOnTermination(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Iops", targetDepth)) {
                    ebs.iops(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Encrypted", targetDepth)) continue;
                ebs.encrypted(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Ebs)ebs.build();
    }

    public static EbsUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EbsUnmarshaller();
        }
        return INSTANCE;
    }
}

