/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersRequest;
import software.amazon.awssdk.util.StringUtils;

public class DetachLoadBalancersRequestMarshaller
implements Marshaller<Request<DetachLoadBalancersRequest>, DetachLoadBalancersRequest> {
    public Request<DetachLoadBalancersRequest> marshall(DetachLoadBalancersRequest detachLoadBalancersRequest) {
        SdkInternalList loadBalancerNamesList;
        if (detachLoadBalancersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachLoadBalancersRequest, "AutoScalingClient");
        request.addParameter("Action", "DetachLoadBalancers");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachLoadBalancersRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)detachLoadBalancersRequest.autoScalingGroupName()));
        }
        if (!(loadBalancerNamesList = (SdkInternalList)detachLoadBalancersRequest.loadBalancerNames()).isEmpty() || !loadBalancerNamesList.isAutoConstruct()) {
            int loadBalancerNamesListIndex = 1;
            for (String loadBalancerNamesListValue : loadBalancerNamesList) {
                if (loadBalancerNamesListValue != null) {
                    request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex, StringUtils.fromString((String)loadBalancerNamesListValue));
                }
                ++loadBalancerNamesListIndex;
            }
        }
        return request;
    }
}

