/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeNotificationConfigurationsRequestMarshaller
implements Marshaller<Request<DescribeNotificationConfigurationsRequest>, DescribeNotificationConfigurationsRequest> {
    public Request<DescribeNotificationConfigurationsRequest> marshall(DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) {
        if (describeNotificationConfigurationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeNotificationConfigurationsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeNotificationConfigurations");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList autoScalingGroupNamesList = (SdkInternalList)describeNotificationConfigurationsRequest.autoScalingGroupNames();
        if (!autoScalingGroupNamesList.isEmpty() || !autoScalingGroupNamesList.isAutoConstruct()) {
            int autoScalingGroupNamesListIndex = 1;
            for (String autoScalingGroupNamesListValue : autoScalingGroupNamesList) {
                if (autoScalingGroupNamesListValue != null) {
                    request.addParameter("AutoScalingGroupNames.member." + autoScalingGroupNamesListIndex, StringUtils.fromString((String)autoScalingGroupNamesListValue));
                }
                ++autoScalingGroupNamesListIndex;
            }
        }
        if (describeNotificationConfigurationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeNotificationConfigurationsRequest.nextToken()));
        }
        if (describeNotificationConfigurationsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeNotificationConfigurationsRequest.maxRecords()));
        }
        return request;
    }
}

