/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionRequest;
import software.amazon.awssdk.util.StringUtils;

public class CompleteLifecycleActionRequestMarshaller
implements Marshaller<Request<CompleteLifecycleActionRequest>, CompleteLifecycleActionRequest> {
    public Request<CompleteLifecycleActionRequest> marshall(CompleteLifecycleActionRequest completeLifecycleActionRequest) {
        if (completeLifecycleActionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)completeLifecycleActionRequest, "AutoScalingClient");
        request.addParameter("Action", "CompleteLifecycleAction");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (completeLifecycleActionRequest.lifecycleHookName() != null) {
            request.addParameter("LifecycleHookName", StringUtils.fromString((String)completeLifecycleActionRequest.lifecycleHookName()));
        }
        if (completeLifecycleActionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)completeLifecycleActionRequest.autoScalingGroupName()));
        }
        if (completeLifecycleActionRequest.lifecycleActionToken() != null) {
            request.addParameter("LifecycleActionToken", StringUtils.fromString((String)completeLifecycleActionRequest.lifecycleActionToken()));
        }
        if (completeLifecycleActionRequest.lifecycleActionResult() != null) {
            request.addParameter("LifecycleActionResult", StringUtils.fromString((String)completeLifecycleActionRequest.lifecycleActionResult()));
        }
        if (completeLifecycleActionRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)completeLifecycleActionRequest.instanceId()));
        }
        return request;
    }
}

