/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.autoscaling.model.BlockDeviceMapping;
import software.amazon.awssdk.services.autoscaling.transform.EbsUnmarshaller;

public class BlockDeviceMappingUnmarshaller
implements Unmarshaller<BlockDeviceMapping, StaxUnmarshallerContext> {
    private static BlockDeviceMappingUnmarshaller INSTANCE;

    public BlockDeviceMapping unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        BlockDeviceMapping.Builder blockDeviceMapping = BlockDeviceMapping.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("VirtualName", targetDepth)) {
                    blockDeviceMapping.virtualName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DeviceName", targetDepth)) {
                    blockDeviceMapping.deviceName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Ebs", targetDepth)) {
                    blockDeviceMapping.ebs(EbsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("NoDevice", targetDepth)) continue;
                blockDeviceMapping.noDevice(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (BlockDeviceMapping)blockDeviceMapping.build();
    }

    public static BlockDeviceMappingUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BlockDeviceMappingUnmarshaller();
        }
        return INSTANCE;
    }
}

