/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.autoscaling.model.ScheduledUpdateGroupAction;
import software.amazon.awssdk.services.autoscaling.model.ScheduledUpdateGroupActionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScheduledActionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeScheduledActionsResponse> {
    private final List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions;
    private final String nextToken;

    private DescribeScheduledActionsResponse(BuilderImpl builder) {
        this.scheduledUpdateGroupActions = builder.scheduledUpdateGroupActions;
        this.nextToken = builder.nextToken;
    }

    public List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions() {
        return this.scheduledUpdateGroupActions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.scheduledUpdateGroupActions() == null ? 0 : this.scheduledUpdateGroupActions().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsResponse)) {
            return false;
        }
        DescribeScheduledActionsResponse other = (DescribeScheduledActionsResponse)((Object)obj);
        if (other.scheduledUpdateGroupActions() == null ^ this.scheduledUpdateGroupActions() == null) {
            return false;
        }
        if (other.scheduledUpdateGroupActions() != null && !other.scheduledUpdateGroupActions().equals(this.scheduledUpdateGroupActions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.scheduledUpdateGroupActions() != null) {
            sb.append("ScheduledUpdateGroupActions: ").append(this.scheduledUpdateGroupActions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsResponse model) {
            this.setScheduledUpdateGroupActions(model.scheduledUpdateGroupActions);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ScheduledUpdateGroupAction> getScheduledUpdateGroupActions() {
            return this.scheduledUpdateGroupActions;
        }

        @Override
        public final Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionsCopier.copy(scheduledUpdateGroupActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledUpdateGroupActions(ScheduledUpdateGroupAction ... scheduledUpdateGroupActions) {
            if (this.scheduledUpdateGroupActions == null) {
                this.scheduledUpdateGroupActions = new SdkInternalList(scheduledUpdateGroupActions.length);
            }
            for (ScheduledUpdateGroupAction e : scheduledUpdateGroupActions) {
                this.scheduledUpdateGroupActions.add(e);
            }
            return this;
        }

        public final void setScheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionsCopier.copy(scheduledUpdateGroupActions);
        }

        @SafeVarargs
        public final void setScheduledUpdateGroupActions(ScheduledUpdateGroupAction ... scheduledUpdateGroupActions) {
            if (this.scheduledUpdateGroupActions == null) {
                this.scheduledUpdateGroupActions = new SdkInternalList(scheduledUpdateGroupActions.length);
            }
            for (ScheduledUpdateGroupAction e : scheduledUpdateGroupActions) {
                this.scheduledUpdateGroupActions.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeScheduledActionsResponse build() {
            return new DescribeScheduledActionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeScheduledActionsResponse> {
        public Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> var1);

        public Builder scheduledUpdateGroupActions(ScheduledUpdateGroupAction ... var1);

        public Builder nextToken(String var1);
    }
}

