/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.autoscaling.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.autoscaling.model.LoadBalancerNamesCopier;
import software.amazon.awssdk.services.autoscaling.model.Tag;
import software.amazon.awssdk.services.autoscaling.model.TagsCopier;
import software.amazon.awssdk.services.autoscaling.model.TargetGroupARNsCopier;
import software.amazon.awssdk.services.autoscaling.model.TerminationPoliciesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateAutoScalingGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateAutoScalingGroupRequest> {
    private final String autoScalingGroupName;
    private final String launchConfigurationName;
    private final String instanceId;
    private final Integer minSize;
    private final Integer maxSize;
    private final Integer desiredCapacity;
    private final Integer defaultCooldown;
    private final List<String> availabilityZones;
    private final List<String> loadBalancerNames;
    private final List<String> targetGroupARNs;
    private final String healthCheckType;
    private final Integer healthCheckGracePeriod;
    private final String placementGroup;
    private final String vpcZoneIdentifier;
    private final List<String> terminationPolicies;
    private final Boolean newInstancesProtectedFromScaleIn;
    private final List<Tag> tags;

    private CreateAutoScalingGroupRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.instanceId = builder.instanceId;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
        this.defaultCooldown = builder.defaultCooldown;
        this.availabilityZones = builder.availabilityZones;
        this.loadBalancerNames = builder.loadBalancerNames;
        this.targetGroupARNs = builder.targetGroupARNs;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.placementGroup = builder.placementGroup;
        this.vpcZoneIdentifier = builder.vpcZoneIdentifier;
        this.terminationPolicies = builder.terminationPolicies;
        this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
        this.tags = builder.tags;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String launchConfigurationName() {
        return this.launchConfigurationName;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Integer minSize() {
        return this.minSize;
    }

    public Integer maxSize() {
        return this.maxSize;
    }

    public Integer desiredCapacity() {
        return this.desiredCapacity;
    }

    public Integer defaultCooldown() {
        return this.defaultCooldown;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public List<String> loadBalancerNames() {
        return this.loadBalancerNames;
    }

    public List<String> targetGroupARNs() {
        return this.targetGroupARNs;
    }

    public String healthCheckType() {
        return this.healthCheckType;
    }

    public Integer healthCheckGracePeriod() {
        return this.healthCheckGracePeriod;
    }

    public String placementGroup() {
        return this.placementGroup;
    }

    public String vpcZoneIdentifier() {
        return this.vpcZoneIdentifier;
    }

    public List<String> terminationPolicies() {
        return this.terminationPolicies;
    }

    public Boolean newInstancesProtectedFromScaleIn() {
        return this.newInstancesProtectedFromScaleIn;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoScalingGroupName() == null ? 0 : this.autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.launchConfigurationName() == null ? 0 : this.launchConfigurationName().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.minSize() == null ? 0 : this.minSize().hashCode());
        hashCode = 31 * hashCode + (this.maxSize() == null ? 0 : this.maxSize().hashCode());
        hashCode = 31 * hashCode + (this.desiredCapacity() == null ? 0 : this.desiredCapacity().hashCode());
        hashCode = 31 * hashCode + (this.defaultCooldown() == null ? 0 : this.defaultCooldown().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.loadBalancerNames() == null ? 0 : this.loadBalancerNames().hashCode());
        hashCode = 31 * hashCode + (this.targetGroupARNs() == null ? 0 : this.targetGroupARNs().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckType() == null ? 0 : this.healthCheckType().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckGracePeriod() == null ? 0 : this.healthCheckGracePeriod().hashCode());
        hashCode = 31 * hashCode + (this.placementGroup() == null ? 0 : this.placementGroup().hashCode());
        hashCode = 31 * hashCode + (this.vpcZoneIdentifier() == null ? 0 : this.vpcZoneIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.terminationPolicies() == null ? 0 : this.terminationPolicies().hashCode());
        hashCode = 31 * hashCode + (this.newInstancesProtectedFromScaleIn() == null ? 0 : this.newInstancesProtectedFromScaleIn().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoScalingGroupRequest)) {
            return false;
        }
        CreateAutoScalingGroupRequest other = (CreateAutoScalingGroupRequest)((Object)obj);
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.launchConfigurationName() == null ^ this.launchConfigurationName() == null) {
            return false;
        }
        if (other.launchConfigurationName() != null && !other.launchConfigurationName().equals(this.launchConfigurationName())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.minSize() == null ^ this.minSize() == null) {
            return false;
        }
        if (other.minSize() != null && !other.minSize().equals(this.minSize())) {
            return false;
        }
        if (other.maxSize() == null ^ this.maxSize() == null) {
            return false;
        }
        if (other.maxSize() != null && !other.maxSize().equals(this.maxSize())) {
            return false;
        }
        if (other.desiredCapacity() == null ^ this.desiredCapacity() == null) {
            return false;
        }
        if (other.desiredCapacity() != null && !other.desiredCapacity().equals(this.desiredCapacity())) {
            return false;
        }
        if (other.defaultCooldown() == null ^ this.defaultCooldown() == null) {
            return false;
        }
        if (other.defaultCooldown() != null && !other.defaultCooldown().equals(this.defaultCooldown())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        if (other.loadBalancerNames() == null ^ this.loadBalancerNames() == null) {
            return false;
        }
        if (other.loadBalancerNames() != null && !other.loadBalancerNames().equals(this.loadBalancerNames())) {
            return false;
        }
        if (other.targetGroupARNs() == null ^ this.targetGroupARNs() == null) {
            return false;
        }
        if (other.targetGroupARNs() != null && !other.targetGroupARNs().equals(this.targetGroupARNs())) {
            return false;
        }
        if (other.healthCheckType() == null ^ this.healthCheckType() == null) {
            return false;
        }
        if (other.healthCheckType() != null && !other.healthCheckType().equals(this.healthCheckType())) {
            return false;
        }
        if (other.healthCheckGracePeriod() == null ^ this.healthCheckGracePeriod() == null) {
            return false;
        }
        if (other.healthCheckGracePeriod() != null && !other.healthCheckGracePeriod().equals(this.healthCheckGracePeriod())) {
            return false;
        }
        if (other.placementGroup() == null ^ this.placementGroup() == null) {
            return false;
        }
        if (other.placementGroup() != null && !other.placementGroup().equals(this.placementGroup())) {
            return false;
        }
        if (other.vpcZoneIdentifier() == null ^ this.vpcZoneIdentifier() == null) {
            return false;
        }
        if (other.vpcZoneIdentifier() != null && !other.vpcZoneIdentifier().equals(this.vpcZoneIdentifier())) {
            return false;
        }
        if (other.terminationPolicies() == null ^ this.terminationPolicies() == null) {
            return false;
        }
        if (other.terminationPolicies() != null && !other.terminationPolicies().equals(this.terminationPolicies())) {
            return false;
        }
        if (other.newInstancesProtectedFromScaleIn() == null ^ this.newInstancesProtectedFromScaleIn() == null) {
            return false;
        }
        if (other.newInstancesProtectedFromScaleIn() != null && !other.newInstancesProtectedFromScaleIn().equals(this.newInstancesProtectedFromScaleIn())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.launchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: ").append(this.launchConfigurationName()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.minSize() != null) {
            sb.append("MinSize: ").append(this.minSize()).append(",");
        }
        if (this.maxSize() != null) {
            sb.append("MaxSize: ").append(this.maxSize()).append(",");
        }
        if (this.desiredCapacity() != null) {
            sb.append("DesiredCapacity: ").append(this.desiredCapacity()).append(",");
        }
        if (this.defaultCooldown() != null) {
            sb.append("DefaultCooldown: ").append(this.defaultCooldown()).append(",");
        }
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        if (this.loadBalancerNames() != null) {
            sb.append("LoadBalancerNames: ").append(this.loadBalancerNames()).append(",");
        }
        if (this.targetGroupARNs() != null) {
            sb.append("TargetGroupARNs: ").append(this.targetGroupARNs()).append(",");
        }
        if (this.healthCheckType() != null) {
            sb.append("HealthCheckType: ").append(this.healthCheckType()).append(",");
        }
        if (this.healthCheckGracePeriod() != null) {
            sb.append("HealthCheckGracePeriod: ").append(this.healthCheckGracePeriod()).append(",");
        }
        if (this.placementGroup() != null) {
            sb.append("PlacementGroup: ").append(this.placementGroup()).append(",");
        }
        if (this.vpcZoneIdentifier() != null) {
            sb.append("VPCZoneIdentifier: ").append(this.vpcZoneIdentifier()).append(",");
        }
        if (this.terminationPolicies() != null) {
            sb.append("TerminationPolicies: ").append(this.terminationPolicies()).append(",");
        }
        if (this.newInstancesProtectedFromScaleIn() != null) {
            sb.append("NewInstancesProtectedFromScaleIn: ").append(this.newInstancesProtectedFromScaleIn()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String launchConfigurationName;
        private String instanceId;
        private Integer minSize;
        private Integer maxSize;
        private Integer desiredCapacity;
        private Integer defaultCooldown;
        private List<String> availabilityZones = new SdkInternalList();
        private List<String> loadBalancerNames = new SdkInternalList();
        private List<String> targetGroupARNs = new SdkInternalList();
        private String healthCheckType;
        private Integer healthCheckGracePeriod;
        private String placementGroup;
        private String vpcZoneIdentifier;
        private List<String> terminationPolicies = new SdkInternalList();
        private Boolean newInstancesProtectedFromScaleIn;
        private List<Tag> tags = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutoScalingGroupRequest model) {
            this.setAutoScalingGroupName(model.autoScalingGroupName);
            this.setLaunchConfigurationName(model.launchConfigurationName);
            this.setInstanceId(model.instanceId);
            this.setMinSize(model.minSize);
            this.setMaxSize(model.maxSize);
            this.setDesiredCapacity(model.desiredCapacity);
            this.setDefaultCooldown(model.defaultCooldown);
            this.setAvailabilityZones(model.availabilityZones);
            this.setLoadBalancerNames(model.loadBalancerNames);
            this.setTargetGroupARNs(model.targetGroupARNs);
            this.setHealthCheckType(model.healthCheckType);
            this.setHealthCheckGracePeriod(model.healthCheckGracePeriod);
            this.setPlacementGroup(model.placementGroup);
            this.setVPCZoneIdentifier(model.vpcZoneIdentifier);
            this.setTerminationPolicies(model.terminationPolicies);
            this.setNewInstancesProtectedFromScaleIn(model.newInstancesProtectedFromScaleIn);
            this.setTags(model.tags);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return this.maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final Integer getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public final Integer getDefaultCooldown() {
            return this.defaultCooldown;
        }

        @Override
        public final Builder defaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public final void setDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            if (this.availabilityZones == null) {
                this.availabilityZones = new SdkInternalList(availabilityZones.length);
            }
            for (String e : availabilityZones) {
                this.availabilityZones.add(e);
            }
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @SafeVarargs
        public final void setAvailabilityZones(String ... availabilityZones) {
            if (this.availabilityZones == null) {
                this.availabilityZones = new SdkInternalList(availabilityZones.length);
            }
            for (String e : availabilityZones) {
                this.availabilityZones.add(e);
            }
        }

        public final Collection<String> getLoadBalancerNames() {
            return this.loadBalancerNames;
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String ... loadBalancerNames) {
            if (this.loadBalancerNames == null) {
                this.loadBalancerNames = new SdkInternalList(loadBalancerNames.length);
            }
            for (String e : loadBalancerNames) {
                this.loadBalancerNames.add(e);
            }
            return this;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        @SafeVarargs
        public final void setLoadBalancerNames(String ... loadBalancerNames) {
            if (this.loadBalancerNames == null) {
                this.loadBalancerNames = new SdkInternalList(loadBalancerNames.length);
            }
            for (String e : loadBalancerNames) {
                this.loadBalancerNames.add(e);
            }
        }

        public final Collection<String> getTargetGroupARNs() {
            return this.targetGroupARNs;
        }

        @Override
        public final Builder targetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupARNs(String ... targetGroupARNs) {
            if (this.targetGroupARNs == null) {
                this.targetGroupARNs = new SdkInternalList(targetGroupARNs.length);
            }
            for (String e : targetGroupARNs) {
                this.targetGroupARNs.add(e);
            }
            return this;
        }

        public final void setTargetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
        }

        @SafeVarargs
        public final void setTargetGroupARNs(String ... targetGroupARNs) {
            if (this.targetGroupARNs == null) {
                this.targetGroupARNs = new SdkInternalList(targetGroupARNs.length);
            }
            for (String e : targetGroupARNs) {
                this.targetGroupARNs.add(e);
            }
        }

        public final String getHealthCheckType() {
            return this.healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        public final Integer getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        public final String getPlacementGroup() {
            return this.placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        public final String getVPCZoneIdentifier() {
            return this.vpcZoneIdentifier;
        }

        @Override
        public final Builder vpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public final void setVPCZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
        }

        public final Collection<String> getTerminationPolicies() {
            return this.terminationPolicies;
        }

        @Override
        public final Builder terminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicies(String ... terminationPolicies) {
            if (this.terminationPolicies == null) {
                this.terminationPolicies = new SdkInternalList(terminationPolicies.length);
            }
            for (String e : terminationPolicies) {
                this.terminationPolicies.add(e);
            }
            return this;
        }

        public final void setTerminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
        }

        @SafeVarargs
        public final void setTerminationPolicies(String ... terminationPolicies) {
            if (this.terminationPolicies == null) {
                this.terminationPolicies = new SdkInternalList(terminationPolicies.length);
            }
            for (String e : terminationPolicies) {
                this.terminationPolicies.add(e);
            }
        }

        public final Boolean getNewInstancesProtectedFromScaleIn() {
            return this.newInstancesProtectedFromScaleIn;
        }

        @Override
        public final Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public final void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public CreateAutoScalingGroupRequest build() {
            return new CreateAutoScalingGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateAutoScalingGroupRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder launchConfigurationName(String var1);

        public Builder instanceId(String var1);

        public Builder minSize(Integer var1);

        public Builder maxSize(Integer var1);

        public Builder desiredCapacity(Integer var1);

        public Builder defaultCooldown(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder loadBalancerNames(Collection<String> var1);

        public Builder loadBalancerNames(String ... var1);

        public Builder targetGroupARNs(Collection<String> var1);

        public Builder targetGroupARNs(String ... var1);

        public Builder healthCheckType(String var1);

        public Builder healthCheckGracePeriod(Integer var1);

        public Builder placementGroup(String var1);

        public Builder vpcZoneIdentifier(String var1);

        public Builder terminationPolicies(Collection<String> var1);

        public Builder terminationPolicies(String ... var1);

        public Builder newInstancesProtectedFromScaleIn(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

