/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ToString;

public class DefaultCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable {
    private static final DefaultCredentialsProvider DEFAULT_CREDENTIALS_PROVIDER = new DefaultCredentialsProvider(DefaultCredentialsProvider.builder());
    private final AwsCredentialsProviderChain providerChain;

    private DefaultCredentialsProvider(Builder builder) {
        this.providerChain = DefaultCredentialsProvider.createChain(builder);
    }

    public static DefaultCredentialsProvider create() {
        return DEFAULT_CREDENTIALS_PROVIDER;
    }

    private static AwsCredentialsProviderChain createChain(Builder builder) {
        AwsCredentialsProvider[] credentialsProviders = new AwsCredentialsProvider[]{SystemPropertyCredentialsProvider.create(), EnvironmentVariableCredentialsProvider.create(), ProfileCredentialsProvider.create(), ((ContainerCredentialsProvider.Builder)ContainerCredentialsProvider.builder().asyncCredentialUpdateEnabled(builder.asyncCredentialUpdateEnabled)).build(), ((InstanceProfileCredentialsProvider.Builder)InstanceProfileCredentialsProvider.builder().asyncCredentialUpdateEnabled(builder.asyncCredentialUpdateEnabled)).build()};
        return AwsCredentialsProviderChain.builder().reuseLastProviderEnabled(builder.reuseLastProviderEnabled).credentialsProviders(credentialsProviders).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public AwsCredentials getCredentials() {
        return this.providerChain.getCredentials();
    }

    public void close() {
        this.providerChain.close();
    }

    public String toString() {
        return ToString.builder((String)"DefaultCredentialsProvider").add("providerChain", (Object)this.providerChain).build();
    }

    public static final class Builder {
        private Boolean reuseLastProviderEnabled = true;
        private Boolean asyncCredentialUpdateEnabled = false;

        private Builder() {
        }

        public Builder reuseLastProviderEnabled(Boolean reuseLastProviderEnabled) {
            this.reuseLastProviderEnabled = reuseLastProviderEnabled;
            return this;
        }

        public Builder asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return this;
        }

        public DefaultCredentialsProvider build() {
            return new DefaultCredentialsProvider(this);
        }
    }
}

