/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.util.Objects;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

public class AwsSessionCredentials
extends AwsCredentials {
    private final String sessionToken;

    private AwsSessionCredentials(String accessKey, String secretKey, String sessionToken) {
        super(accessKey, secretKey);
        this.sessionToken = (String)Validate.notNull((Object)sessionToken, (String)"Session token cannot be null.", (Object[])new Object[0]);
    }

    public static AwsSessionCredentials create(String accessKey, String secretKey, String sessionToken) {
        return new AwsSessionCredentials(accessKey, secretKey, sessionToken);
    }

    public final String sessionToken() {
        return this.sessionToken;
    }

    @Override
    public String toString() {
        return ToString.builder((String)"AwsSessionCredentials").add("accessKeyId", (Object)this.accessKeyId()).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AwsSessionCredentials that = (AwsSessionCredentials)o;
        return Objects.equals(this.sessionToken, that.sessionToken);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sessionToken);
    }
}

