/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.authcrt.signer.internal;

import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.crt.auth.credentials.Credentials;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public class SigningUtils {
    public static final ExecutionAttribute<Clock> SIGNING_CLOCK = new ExecutionAttribute("SigningClock");
    private static final String REGION_SET_NAME = "X-amz-region-set";
    private static final Set<String> FORBIDDEN_HEADERS = SigningUtils.buildForbiddenHeaderSet();
    private static final Set<String> FORBIDDEN_PARAMS = SigningUtils.buildForbiddenQueryParamSet();

    private SigningUtils() {
    }

    public static Credentials buildCredentials(ExecutionAttributes executionAttributes) {
        AwsCredentials sdkCredentials = SigningUtils.sanitizeCredentials((AwsCredentials)executionAttributes.getAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS));
        byte[] sessionToken = null;
        if (sdkCredentials instanceof AwsSessionCredentials) {
            AwsSessionCredentials sessionCreds = (AwsSessionCredentials)sdkCredentials;
            sessionToken = sessionCreds.sessionToken().getBytes(StandardCharsets.UTF_8);
        }
        return new Credentials(sdkCredentials.accessKeyId().getBytes(StandardCharsets.UTF_8), sdkCredentials.secretAccessKey().getBytes(StandardCharsets.UTF_8), sessionToken);
    }

    public static Clock getSigningClock(ExecutionAttributes executionAttributes) {
        Clock clock = (Clock)executionAttributes.getAttribute(SIGNING_CLOCK);
        if (clock != null) {
            return clock;
        }
        Clock baseClock = Clock.systemUTC();
        Optional<Integer> timeOffset = Optional.ofNullable((Integer)executionAttributes.getAttribute(SdkExecutionAttribute.TIME_OFFSET));
        return timeOffset.map(offset -> Clock.offset(baseClock, Duration.ofSeconds(-offset.intValue()))).orElse(baseClock);
    }

    public static AwsCredentials sanitizeCredentials(AwsCredentials credentials) {
        String accessKeyId = StringUtils.trim((String)credentials.accessKeyId());
        String secretKey = StringUtils.trim((String)credentials.secretAccessKey());
        if (credentials instanceof AwsSessionCredentials) {
            AwsSessionCredentials sessionCredentials = (AwsSessionCredentials)credentials;
            return AwsSessionCredentials.create((String)accessKeyId, (String)secretKey, (String)StringUtils.trim((String)sessionCredentials.sessionToken()));
        }
        return AwsBasicCredentials.create((String)accessKeyId, (String)secretKey);
    }

    public static SdkHttpFullRequest sanitizeSdkRequestForCrtSigning(SdkHttpFullRequest request) {
        SdkHttpFullRequest.Builder builder = request.toBuilder();
        String path = builder.encodedPath();
        if (path == null || path.length() == 0) {
            builder.encodedPath("/");
        }
        builder.clearHeaders();
        request.forEachHeader((name, value) -> {
            if (!FORBIDDEN_HEADERS.contains(name)) {
                builder.putHeader(name, value);
            }
        });
        String hostHeader = SdkHttpUtils.isUsingStandardPort((String)request.protocol(), (Integer)request.port()) ? request.host() : request.host() + ":" + request.port();
        builder.putHeader("Host", hostHeader);
        builder.clearQueryParameters();
        request.forEachRawQueryParameter((key, value) -> {
            if (!FORBIDDEN_PARAMS.contains(key)) {
                builder.putRawQueryParameter(key, value);
            }
        });
        return builder.build();
    }

    private static Set<String> buildForbiddenHeaderSet() {
        TreeSet<String> forbiddenHeaders = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        forbiddenHeaders.add("x-amz-content-sha256");
        forbiddenHeaders.add("X-Amz-Date");
        forbiddenHeaders.add("Authorization");
        forbiddenHeaders.add(REGION_SET_NAME);
        return forbiddenHeaders;
    }

    private static Set<String> buildForbiddenQueryParamSet() {
        TreeSet<String> forbiddenParams = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        forbiddenParams.add("X-Amz-Signature");
        forbiddenParams.add("X-Amz-Date");
        forbiddenParams.add("X-Amz-Credential");
        forbiddenParams.add("X-Amz-Algorithm");
        forbiddenParams.add("X-Amz-SignedHeaders");
        forbiddenParams.add(REGION_SET_NAME);
        forbiddenParams.add("X-Amz-Expires");
        return forbiddenParams;
    }
}

