/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.authcrt.signer.internal;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.authcrt.signer.internal.CrtHttpRequestConverter;
import software.amazon.awssdk.authcrt.signer.internal.SdkSigningResult;
import software.amazon.awssdk.authcrt.signer.internal.SigningUtils;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.crt.auth.signing.AwsSigner;
import software.amazon.awssdk.crt.auth.signing.AwsSigningConfig;
import software.amazon.awssdk.crt.auth.signing.AwsSigningResult;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.http.SdkHttpFullRequest;

@SdkInternalApi
public class AwsCrt4aSigningAdapter {
    private final CrtHttpRequestConverter requestConverter = new CrtHttpRequestConverter();

    public SdkHttpFullRequest signRequest(SdkHttpFullRequest request, AwsSigningConfig signingConfig) {
        HttpRequest crtRequest = this.requestConverter.requestToCrt(SigningUtils.sanitizeSdkRequestForCrtSigning(request));
        CompletableFuture future = AwsSigner.signRequest((HttpRequest)crtRequest, (AwsSigningConfig)signingConfig);
        try {
            HttpRequest signedRequest = (HttpRequest)future.get();
            return this.requestConverter.crtRequestToHttp(request, signedRequest);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to sign request: " + e.getMessage()).cause((Throwable)e).build();
        }
    }

    public SdkSigningResult sign(SdkHttpFullRequest request, AwsSigningConfig signingConfig) {
        HttpRequest crtRequest = this.requestConverter.requestToCrt(SigningUtils.sanitizeSdkRequestForCrtSigning(request));
        CompletableFuture future = AwsSigner.sign((HttpRequest)crtRequest, (AwsSigningConfig)signingConfig);
        try {
            AwsSigningResult signingResult = (AwsSigningResult)future.get();
            return this.requestConverter.crtResultToAws(request, signingResult);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to sign request: " + e.getMessage()).cause((Throwable)e).build();
        }
    }

    public byte[] signChunk(byte[] chunkBody, byte[] previousSignature, AwsSigningConfig signingConfig) {
        HttpRequestBodyStream crtBody = this.requestConverter.toCrtStream(chunkBody);
        CompletableFuture future = AwsSigner.signChunk((HttpRequestBodyStream)crtBody, (byte[])previousSignature, (AwsSigningConfig)signingConfig);
        try {
            return (byte[])future.get();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to sign chunk: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

