/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.authcrt.signer.internal;

import java.nio.charset.StandardCharsets;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.CredentialUtils;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.auth.signer.S3SignerExecutionAttribute;
import software.amazon.awssdk.auth.signer.internal.Aws4SignerUtils;
import software.amazon.awssdk.auth.signer.internal.chunkedencoding.AwsChunkSigner;
import software.amazon.awssdk.auth.signer.internal.chunkedencoding.AwsChunkedEncodingConfig;
import software.amazon.awssdk.auth.signer.internal.chunkedencoding.AwsChunkedEncodingInputStream;
import software.amazon.awssdk.authcrt.signer.AwsCrtS3V4aSigner;
import software.amazon.awssdk.authcrt.signer.internal.AwsCrt4aSigningAdapter;
import software.amazon.awssdk.authcrt.signer.internal.SdkSigningResult;
import software.amazon.awssdk.authcrt.signer.internal.SigningConfigProvider;
import software.amazon.awssdk.authcrt.signer.internal.chunkedencoding.AwsS3V4aChunkSigner;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.crt.auth.signing.AwsSigningConfig;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;

@SdkInternalApi
public final class DefaultAwsCrtS3V4aSigner
implements AwsCrtS3V4aSigner {
    private final AwsCrt4aSigningAdapter signerAdapter;
    private final SigningConfigProvider configProvider;

    DefaultAwsCrtS3V4aSigner(AwsCrt4aSigningAdapter signerAdapter, SigningConfigProvider signingConfigProvider) {
        this.signerAdapter = signerAdapter;
        this.configProvider = signingConfigProvider;
    }

    public static AwsCrtS3V4aSigner create() {
        return new DefaultAwsCrtS3V4aSigner(new AwsCrt4aSigningAdapter(), new SigningConfigProvider());
    }

    public SdkHttpFullRequest sign(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        if (this.credentialsAreAnonymous(executionAttributes)) {
            return request;
        }
        AwsSigningConfig requestSigningConfig = this.configProvider.createS3CrtSigningConfig(executionAttributes);
        if (this.shouldSignPayload(request, executionAttributes)) {
            requestSigningConfig.setSignedBodyValue("STREAMING-AWS4-ECDSA-P256-SHA256-PAYLOAD");
            SdkHttpFullRequest.Builder mutableRequest = request.toBuilder();
            this.setHeaderContentLength(mutableRequest);
            SdkSigningResult signingResult = this.signerAdapter.sign(mutableRequest.build(), requestSigningConfig);
            AwsSigningConfig chunkConfig = this.configProvider.createChunkedSigningConfig(executionAttributes);
            return this.enablePayloadSigning(signingResult, chunkConfig);
        }
        requestSigningConfig.setSignedBodyValue("UNSIGNED-PAYLOAD");
        return this.signerAdapter.signRequest(request, requestSigningConfig);
    }

    public SdkHttpFullRequest presign(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        if (this.credentialsAreAnonymous(executionAttributes)) {
            return request;
        }
        return this.signerAdapter.signRequest(request, this.configProvider.createS3CrtPresigningConfig(executionAttributes));
    }

    private boolean credentialsAreAnonymous(ExecutionAttributes executionAttributes) {
        return CredentialUtils.isAnonymous((AwsCredentials)((AwsCredentials)executionAttributes.getAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS)));
    }

    private boolean shouldSignPayload(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        if (!request.protocol().equals("https") && request.contentStreamProvider().isPresent()) {
            return true;
        }
        boolean payloadSigning = this.booleanValue((Boolean)executionAttributes.getAttribute(S3SignerExecutionAttribute.ENABLE_PAYLOAD_SIGNING));
        boolean chunkedEncoding = this.booleanValue((Boolean)executionAttributes.getAttribute(S3SignerExecutionAttribute.ENABLE_CHUNKED_ENCODING));
        return payloadSigning && chunkedEncoding;
    }

    private void setHeaderContentLength(SdkHttpFullRequest.Builder mutableRequest) {
        long originalContentLength = Aws4SignerUtils.calculateRequestContentLength((SdkHttpFullRequest.Builder)mutableRequest);
        mutableRequest.putHeader("x-amz-decoded-content-length", Long.toString(originalContentLength));
        mutableRequest.putHeader("Content-Length", Long.toString(AwsChunkedEncodingInputStream.calculateStreamContentLength((long)originalContentLength, (int)AwsS3V4aChunkSigner.getSignatureLength(), (AwsChunkedEncodingConfig)AwsChunkedEncodingConfig.create())));
    }

    private SdkHttpFullRequest enablePayloadSigning(SdkSigningResult signingResult, AwsSigningConfig chunkConfig) {
        SdkHttpFullRequest signedRequest = signingResult.getSignedRequest();
        byte[] signature = signingResult.getSignature();
        SdkHttpFullRequest.Builder mutableSignedRequest = signedRequest.toBuilder();
        ContentStreamProvider streamProvider = mutableSignedRequest.contentStreamProvider();
        AwsS3V4aChunkSigner chunkSigner = new AwsS3V4aChunkSigner(this.signerAdapter, chunkConfig);
        mutableSignedRequest.contentStreamProvider(() -> new AwsChunkedEncodingInputStream(streamProvider.newStream(), new String(signature, StandardCharsets.UTF_8), (AwsChunkSigner)chunkSigner, AwsChunkedEncodingConfig.create()));
        return mutableSignedRequest.build();
    }

    private boolean booleanValue(Boolean attribute) {
        return Boolean.TRUE.equals(attribute);
    }
}

