/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerAsyncClient;
import software.amazon.awssdk.services.auditmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse;

public class ListAssessmentsPublisher
implements SdkPublisher<ListAssessmentsResponse> {
    private final AuditManagerAsyncClient client;
    private final ListAssessmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssessmentsPublisher(AuditManagerAsyncClient client, ListAssessmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssessmentsPublisher(AuditManagerAsyncClient client, ListAssessmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssessmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssessmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAssessmentsResponseFetcher
    implements AsyncPageFetcher<ListAssessmentsResponse> {
        private ListAssessmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssessmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssessmentsResponse> nextPage(ListAssessmentsResponse previousPage) {
            if (previousPage == null) {
                return ListAssessmentsPublisher.this.client.listAssessments(ListAssessmentsPublisher.this.firstRequest);
            }
            return ListAssessmentsPublisher.this.client.listAssessments((ListAssessmentsRequest)((Object)ListAssessmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

