/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.DelegationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DelegationMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DelegationMetadata> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DelegationMetadata.getter(DelegationMetadata::id)).setter(DelegationMetadata.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ASSESSMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentName").getter(DelegationMetadata.getter(DelegationMetadata::assessmentName)).setter(DelegationMetadata.setter(Builder::assessmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentName").build()}).build();
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentId").getter(DelegationMetadata.getter(DelegationMetadata::assessmentId)).setter(DelegationMetadata.setter(Builder::assessmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DelegationMetadata.getter(DelegationMetadata::statusAsString)).setter(DelegationMetadata.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DelegationMetadata.getter(DelegationMetadata::roleArn)).setter(DelegationMetadata.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(DelegationMetadata.getter(DelegationMetadata::creationTime)).setter(DelegationMetadata.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> CONTROL_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlSetName").getter(DelegationMetadata.getter(DelegationMetadata::controlSetName)).setter(DelegationMetadata.setter(Builder::controlSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSetName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ASSESSMENT_NAME_FIELD, ASSESSMENT_ID_FIELD, STATUS_FIELD, ROLE_ARN_FIELD, CREATION_TIME_FIELD, CONTROL_SET_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DelegationMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String assessmentName;
    private final String assessmentId;
    private final String status;
    private final String roleArn;
    private final Instant creationTime;
    private final String controlSetName;

    private DelegationMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.assessmentName = builder.assessmentName;
        this.assessmentId = builder.assessmentId;
        this.status = builder.status;
        this.roleArn = builder.roleArn;
        this.creationTime = builder.creationTime;
        this.controlSetName = builder.controlSetName;
    }

    public final String id() {
        return this.id;
    }

    public final String assessmentName() {
        return this.assessmentName;
    }

    public final String assessmentId() {
        return this.assessmentId;
    }

    public final DelegationStatus status() {
        return DelegationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String controlSetName() {
        return this.controlSetName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlSetName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegationMetadata)) {
            return false;
        }
        DelegationMetadata other = (DelegationMetadata)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.assessmentName(), other.assessmentName()) && Objects.equals(this.assessmentId(), other.assessmentId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.controlSetName(), other.controlSetName());
    }

    public final String toString() {
        return ToString.builder((String)"DelegationMetadata").add("Id", (Object)this.id()).add("AssessmentName", (Object)(this.assessmentName() == null ? null : "*** Sensitive Data Redacted ***")).add("AssessmentId", (Object)this.assessmentId()).add("Status", (Object)this.statusAsString()).add("RoleArn", (Object)this.roleArn()).add("CreationTime", (Object)this.creationTime()).add("ControlSetName", (Object)this.controlSetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "assessmentName": {
                return Optional.ofNullable(clazz.cast(this.assessmentName()));
            }
            case "assessmentId": {
                return Optional.ofNullable(clazz.cast(this.assessmentId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "controlSetName": {
                return Optional.ofNullable(clazz.cast(this.controlSetName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("assessmentName", ASSESSMENT_NAME_FIELD);
        map.put("assessmentId", ASSESSMENT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("controlSetName", CONTROL_SET_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DelegationMetadata, T> g) {
        return obj -> g.apply((DelegationMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String assessmentName;
        private String assessmentId;
        private String status;
        private String roleArn;
        private Instant creationTime;
        private String controlSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(DelegationMetadata model) {
            this.id(model.id);
            this.assessmentName(model.assessmentName);
            this.assessmentId(model.assessmentId);
            this.status(model.status);
            this.roleArn(model.roleArn);
            this.creationTime(model.creationTime);
            this.controlSetName(model.controlSetName);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAssessmentName() {
            return this.assessmentName;
        }

        public final void setAssessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
        }

        @Override
        public final Builder assessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
            return this;
        }

        public final String getAssessmentId() {
            return this.assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DelegationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getControlSetName() {
            return this.controlSetName;
        }

        public final void setControlSetName(String controlSetName) {
            this.controlSetName = controlSetName;
        }

        @Override
        public final Builder controlSetName(String controlSetName) {
            this.controlSetName = controlSetName;
            return this;
        }

        public DelegationMetadata build() {
            return new DelegationMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DelegationMetadata> {
        public Builder id(String var1);

        public Builder assessmentName(String var1);

        public Builder assessmentId(String var1);

        public Builder status(String var1);

        public Builder status(DelegationStatus var1);

        public Builder roleArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder controlSetName(String var1);
    }
}

