/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControlSet;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControlSetsCopier;
import software.amazon.awssdk.services.auditmanager.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssessmentFrameworkRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, CreateAssessmentFrameworkRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAssessmentFrameworkRequest.getter(CreateAssessmentFrameworkRequest::name)).setter(CreateAssessmentFrameworkRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAssessmentFrameworkRequest.getter(CreateAssessmentFrameworkRequest::description)).setter(CreateAssessmentFrameworkRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceType").getter(CreateAssessmentFrameworkRequest.getter(CreateAssessmentFrameworkRequest::complianceType)).setter(CreateAssessmentFrameworkRequest.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceType").build()}).build();
    private static final SdkField<List<CreateAssessmentFrameworkControlSet>> CONTROL_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("controlSets").getter(CreateAssessmentFrameworkRequest.getter(CreateAssessmentFrameworkRequest::controlSets)).setter(CreateAssessmentFrameworkRequest.setter(Builder::controlSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateAssessmentFrameworkControlSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAssessmentFrameworkRequest.getter(CreateAssessmentFrameworkRequest::tags)).setter(CreateAssessmentFrameworkRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, COMPLIANCE_TYPE_FIELD, CONTROL_SETS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAssessmentFrameworkRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String complianceType;
    private final List<CreateAssessmentFrameworkControlSet> controlSets;
    private final Map<String, String> tags;

    private CreateAssessmentFrameworkRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.complianceType = builder.complianceType;
        this.controlSets = builder.controlSets;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String complianceType() {
        return this.complianceType;
    }

    public final boolean hasControlSets() {
        return this.controlSets != null && !(this.controlSets instanceof SdkAutoConstructList);
    }

    public final List<CreateAssessmentFrameworkControlSet> controlSets() {
        return this.controlSets;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControlSets() ? this.controlSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssessmentFrameworkRequest)) {
            return false;
        }
        CreateAssessmentFrameworkRequest other = (CreateAssessmentFrameworkRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.complianceType(), other.complianceType()) && this.hasControlSets() == other.hasControlSets() && Objects.equals(this.controlSets(), other.controlSets()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAssessmentFrameworkRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ComplianceType", (Object)(this.complianceType() == null ? null : "*** Sensitive Data Redacted ***")).add("ControlSets", this.hasControlSets() ? this.controlSets() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "complianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceType()));
            }
            case "controlSets": {
                return Optional.ofNullable(clazz.cast(this.controlSets()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("complianceType", COMPLIANCE_TYPE_FIELD);
        map.put("controlSets", CONTROL_SETS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAssessmentFrameworkRequest, T> g) {
        return obj -> g.apply((CreateAssessmentFrameworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String complianceType;
        private List<CreateAssessmentFrameworkControlSet> controlSets = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssessmentFrameworkRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.complianceType(model.complianceType);
            this.controlSets(model.controlSets);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final List<CreateAssessmentFrameworkControlSet.Builder> getControlSets() {
            List<CreateAssessmentFrameworkControlSet.Builder> result = CreateAssessmentFrameworkControlSetsCopier.copyToBuilder(this.controlSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlSets(Collection<CreateAssessmentFrameworkControlSet.BuilderImpl> controlSets) {
            this.controlSets = CreateAssessmentFrameworkControlSetsCopier.copyFromBuilder(controlSets);
        }

        @Override
        public final Builder controlSets(Collection<CreateAssessmentFrameworkControlSet> controlSets) {
            this.controlSets = CreateAssessmentFrameworkControlSetsCopier.copy(controlSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlSets(CreateAssessmentFrameworkControlSet ... controlSets) {
            this.controlSets(Arrays.asList(controlSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlSets(Consumer<CreateAssessmentFrameworkControlSet.Builder> ... controlSets) {
            this.controlSets(Stream.of(controlSets).map(c -> (CreateAssessmentFrameworkControlSet)((CreateAssessmentFrameworkControlSet.Builder)CreateAssessmentFrameworkControlSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssessmentFrameworkRequest build() {
            return new CreateAssessmentFrameworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAssessmentFrameworkRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder complianceType(String var1);

        public Builder controlSets(Collection<CreateAssessmentFrameworkControlSet> var1);

        public Builder controlSets(CreateAssessmentFrameworkControlSet ... var1);

        public Builder controlSets(Consumer<CreateAssessmentFrameworkControlSet.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

