/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.QueryExecutionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryExecutionStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryExecutionStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryExecutionStatus.getter(QueryExecutionStatus::stateAsString)).setter(QueryExecutionStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_CHANGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryExecutionStatus.getter(QueryExecutionStatus::stateChangeReason)).setter(QueryExecutionStatus.setter(Builder::stateChangeReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()}).build();
    private static final SdkField<Instant> SUBMISSION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(QueryExecutionStatus.getter(QueryExecutionStatus::submissionDateTime)).setter(QueryExecutionStatus.setter(Builder::submissionDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmissionDateTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(QueryExecutionStatus.getter(QueryExecutionStatus::completionDateTime)).setter(QueryExecutionStatus.setter(Builder::completionDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, STATE_CHANGE_REASON_FIELD, SUBMISSION_DATE_TIME_FIELD, COMPLETION_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String state;
    private final String stateChangeReason;
    private final Instant submissionDateTime;
    private final Instant completionDateTime;

    private QueryExecutionStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.submissionDateTime = builder.submissionDateTime;
        this.completionDateTime = builder.completionDateTime;
    }

    public QueryExecutionState state() {
        return QueryExecutionState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String stateChangeReason() {
        return this.stateChangeReason;
    }

    public Instant submissionDateTime() {
        return this.submissionDateTime;
    }

    public Instant completionDateTime() {
        return this.completionDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.submissionDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionStatus)) {
            return false;
        }
        QueryExecutionStatus other = (QueryExecutionStatus)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason()) && Objects.equals(this.submissionDateTime(), other.submissionDateTime()) && Objects.equals(this.completionDateTime(), other.completionDateTime());
    }

    public String toString() {
        return ToString.builder((String)"QueryExecutionStatus").add("State", (Object)this.stateAsString()).add("StateChangeReason", (Object)this.stateChangeReason()).add("SubmissionDateTime", (Object)this.submissionDateTime()).add("CompletionDateTime", (Object)this.completionDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.stateChangeReason()));
            }
            case "SubmissionDateTime": {
                return Optional.ofNullable(clazz.cast(this.submissionDateTime()));
            }
            case "CompletionDateTime": {
                return Optional.ofNullable(clazz.cast(this.completionDateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryExecutionStatus, T> g) {
        return obj -> g.apply((QueryExecutionStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private String stateChangeReason;
        private Instant submissionDateTime;
        private Instant completionDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecutionStatus model) {
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
            this.submissionDateTime(model.submissionDateTime);
            this.completionDateTime(model.completionDateTime);
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(QueryExecutionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateChangeReason() {
            return this.stateChangeReason;
        }

        @Override
        public final Builder stateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
        }

        public final Instant getSubmissionDateTime() {
            return this.submissionDateTime;
        }

        @Override
        public final Builder submissionDateTime(Instant submissionDateTime) {
            this.submissionDateTime = submissionDateTime;
            return this;
        }

        public final void setSubmissionDateTime(Instant submissionDateTime) {
            this.submissionDateTime = submissionDateTime;
        }

        public final Instant getCompletionDateTime() {
            return this.completionDateTime;
        }

        @Override
        public final Builder completionDateTime(Instant completionDateTime) {
            this.completionDateTime = completionDateTime;
            return this;
        }

        public final void setCompletionDateTime(Instant completionDateTime) {
            this.completionDateTime = completionDateTime;
        }

        public QueryExecutionStatus build() {
            return new QueryExecutionStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryExecutionStatus> {
        public Builder state(String var1);

        public Builder state(QueryExecutionState var1);

        public Builder stateChangeReason(String var1);

        public Builder submissionDateTime(Instant var1);

        public Builder completionDateTime(Instant var1);
    }
}

