/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.WorkGroupConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkGroupRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, CreateWorkGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateWorkGroupRequest.getter(CreateWorkGroupRequest::name)).setter(CreateWorkGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<WorkGroupConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateWorkGroupRequest.getter(CreateWorkGroupRequest::configuration)).setter(CreateWorkGroupRequest.setter(Builder::configuration)).constructor(WorkGroupConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateWorkGroupRequest.getter(CreateWorkGroupRequest::description)).setter(CreateWorkGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONFIGURATION_FIELD, DESCRIPTION_FIELD));
    private final String name;
    private final WorkGroupConfiguration configuration;
    private final String description;

    private CreateWorkGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.description = builder.description;
    }

    public String name() {
        return this.name;
    }

    public WorkGroupConfiguration configuration() {
        return this.configuration;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkGroupRequest)) {
            return false;
        }
        CreateWorkGroupRequest other = (CreateWorkGroupRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"CreateWorkGroupRequest").add("Name", (Object)this.name()).add("Configuration", (Object)this.configuration()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkGroupRequest, T> g) {
        return obj -> g.apply((CreateWorkGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String name;
        private WorkGroupConfiguration configuration;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkGroupRequest model) {
            super(model);
            this.name(model.name);
            this.configuration(model.configuration);
            this.description(model.description);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final WorkGroupConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(WorkGroupConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(WorkGroupConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkGroupRequest build() {
            return new CreateWorkGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkGroupRequest> {
        public Builder name(String var1);

        public Builder configuration(WorkGroupConfiguration var1);

        default public Builder configuration(Consumer<WorkGroupConfiguration.Builder> configuration) {
            return this.configuration((WorkGroupConfiguration)((WorkGroupConfiguration.Builder)WorkGroupConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

