/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stage statistics such as input and output rows and bytes, execution time and stage state. This information also
 * includes substages and the query stage plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryStage implements SdkPojo, Serializable, ToCopyableBuilder<QueryStage.Builder, QueryStage> {
    private static final SdkField<Long> STAGE_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("StageId")
            .getter(getter(QueryStage::stageId)).setter(setter(Builder::stageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(QueryStage::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Long> OUTPUT_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OutputBytes").getter(getter(QueryStage::outputBytes)).setter(setter(Builder::outputBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBytes").build()).build();

    private static final SdkField<Long> OUTPUT_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OutputRows").getter(getter(QueryStage::outputRows)).setter(setter(Builder::outputRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputRows").build()).build();

    private static final SdkField<Long> INPUT_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("InputBytes").getter(getter(QueryStage::inputBytes)).setter(setter(Builder::inputBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputBytes").build()).build();

    private static final SdkField<Long> INPUT_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("InputRows")
            .getter(getter(QueryStage::inputRows)).setter(setter(Builder::inputRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputRows").build()).build();

    private static final SdkField<Long> EXECUTION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ExecutionTime").getter(getter(QueryStage::executionTime)).setter(setter(Builder::executionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()).build();

    private static final SdkField<QueryStagePlanNode> QUERY_STAGE_PLAN_FIELD = SdkField
            .<QueryStagePlanNode> builder(MarshallingType.SDK_POJO).memberName("QueryStagePlan")
            .getter(getter(QueryStage::queryStagePlan)).setter(setter(Builder::queryStagePlan))
            .constructor(QueryStagePlanNode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStagePlan").build()).build();

    private static final SdkField<List<QueryStage>> SUB_STAGES_FIELD = SdkField
            .<List<QueryStage>> builder(MarshallingType.LIST)
            .memberName("SubStages")
            .getter(getter(QueryStage::subStages))
            .setter(setter(Builder::subStages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubStages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryStage> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryStage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_ID_FIELD, STATE_FIELD,
            OUTPUT_BYTES_FIELD, OUTPUT_ROWS_FIELD, INPUT_BYTES_FIELD, INPUT_ROWS_FIELD, EXECUTION_TIME_FIELD,
            QUERY_STAGE_PLAN_FIELD, SUB_STAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long stageId;

    private final String state;

    private final Long outputBytes;

    private final Long outputRows;

    private final Long inputBytes;

    private final Long inputRows;

    private final Long executionTime;

    private final QueryStagePlanNode queryStagePlan;

    private final List<QueryStage> subStages;

    private QueryStage(BuilderImpl builder) {
        this.stageId = builder.stageId;
        this.state = builder.state;
        this.outputBytes = builder.outputBytes;
        this.outputRows = builder.outputRows;
        this.inputBytes = builder.inputBytes;
        this.inputRows = builder.inputRows;
        this.executionTime = builder.executionTime;
        this.queryStagePlan = builder.queryStagePlan;
        this.subStages = builder.subStages;
    }

    /**
     * <p>
     * The identifier for a stage.
     * </p>
     * 
     * @return The identifier for a stage.
     */
    public final Long stageId() {
        return stageId;
    }

    /**
     * <p>
     * State of the stage after query execution.
     * </p>
     * 
     * @return State of the stage after query execution.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The number of bytes output from the stage after execution.
     * </p>
     * 
     * @return The number of bytes output from the stage after execution.
     */
    public final Long outputBytes() {
        return outputBytes;
    }

    /**
     * <p>
     * The number of rows output from the stage after execution.
     * </p>
     * 
     * @return The number of rows output from the stage after execution.
     */
    public final Long outputRows() {
        return outputRows;
    }

    /**
     * <p>
     * The number of bytes input into the stage for execution.
     * </p>
     * 
     * @return The number of bytes input into the stage for execution.
     */
    public final Long inputBytes() {
        return inputBytes;
    }

    /**
     * <p>
     * The number of rows input into the stage for execution.
     * </p>
     * 
     * @return The number of rows input into the stage for execution.
     */
    public final Long inputRows() {
        return inputRows;
    }

    /**
     * <p>
     * Time taken to execute this stage.
     * </p>
     * 
     * @return Time taken to execute this stage.
     */
    public final Long executionTime() {
        return executionTime;
    }

    /**
     * <p>
     * Stage plan information such as name, identifier, sub plans, and source stages.
     * </p>
     * 
     * @return Stage plan information such as name, identifier, sub plans, and source stages.
     */
    public final QueryStagePlanNode queryStagePlan() {
        return queryStagePlan;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubStages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubStages() {
        return subStages != null && !(subStages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of sub query stages that form this stage execution plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubStages} method.
     * </p>
     * 
     * @return List of sub query stages that form this stage execution plan.
     */
    public final List<QueryStage> subStages() {
        return subStages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stageId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(outputBytes());
        hashCode = 31 * hashCode + Objects.hashCode(outputRows());
        hashCode = 31 * hashCode + Objects.hashCode(inputBytes());
        hashCode = 31 * hashCode + Objects.hashCode(inputRows());
        hashCode = 31 * hashCode + Objects.hashCode(executionTime());
        hashCode = 31 * hashCode + Objects.hashCode(queryStagePlan());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubStages() ? subStages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStage)) {
            return false;
        }
        QueryStage other = (QueryStage) obj;
        return Objects.equals(stageId(), other.stageId()) && Objects.equals(state(), other.state())
                && Objects.equals(outputBytes(), other.outputBytes()) && Objects.equals(outputRows(), other.outputRows())
                && Objects.equals(inputBytes(), other.inputBytes()) && Objects.equals(inputRows(), other.inputRows())
                && Objects.equals(executionTime(), other.executionTime())
                && Objects.equals(queryStagePlan(), other.queryStagePlan()) && hasSubStages() == other.hasSubStages()
                && Objects.equals(subStages(), other.subStages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryStage").add("StageId", stageId()).add("State", state()).add("OutputBytes", outputBytes())
                .add("OutputRows", outputRows()).add("InputBytes", inputBytes()).add("InputRows", inputRows())
                .add("ExecutionTime", executionTime()).add("QueryStagePlan", queryStagePlan())
                .add("SubStages", hasSubStages() ? subStages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StageId":
            return Optional.ofNullable(clazz.cast(stageId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "OutputBytes":
            return Optional.ofNullable(clazz.cast(outputBytes()));
        case "OutputRows":
            return Optional.ofNullable(clazz.cast(outputRows()));
        case "InputBytes":
            return Optional.ofNullable(clazz.cast(inputBytes()));
        case "InputRows":
            return Optional.ofNullable(clazz.cast(inputRows()));
        case "ExecutionTime":
            return Optional.ofNullable(clazz.cast(executionTime()));
        case "QueryStagePlan":
            return Optional.ofNullable(clazz.cast(queryStagePlan()));
        case "SubStages":
            return Optional.ofNullable(clazz.cast(subStages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StageId", STAGE_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("OutputBytes", OUTPUT_BYTES_FIELD);
        map.put("OutputRows", OUTPUT_ROWS_FIELD);
        map.put("InputBytes", INPUT_BYTES_FIELD);
        map.put("InputRows", INPUT_ROWS_FIELD);
        map.put("ExecutionTime", EXECUTION_TIME_FIELD);
        map.put("QueryStagePlan", QUERY_STAGE_PLAN_FIELD);
        map.put("SubStages", SUB_STAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryStage, T> g) {
        return obj -> g.apply((QueryStage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryStage> {
        /**
         * <p>
         * The identifier for a stage.
         * </p>
         * 
         * @param stageId
         *        The identifier for a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageId(Long stageId);

        /**
         * <p>
         * State of the stage after query execution.
         * </p>
         * 
         * @param state
         *        State of the stage after query execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The number of bytes output from the stage after execution.
         * </p>
         * 
         * @param outputBytes
         *        The number of bytes output from the stage after execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputBytes(Long outputBytes);

        /**
         * <p>
         * The number of rows output from the stage after execution.
         * </p>
         * 
         * @param outputRows
         *        The number of rows output from the stage after execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputRows(Long outputRows);

        /**
         * <p>
         * The number of bytes input into the stage for execution.
         * </p>
         * 
         * @param inputBytes
         *        The number of bytes input into the stage for execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputBytes(Long inputBytes);

        /**
         * <p>
         * The number of rows input into the stage for execution.
         * </p>
         * 
         * @param inputRows
         *        The number of rows input into the stage for execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputRows(Long inputRows);

        /**
         * <p>
         * Time taken to execute this stage.
         * </p>
         * 
         * @param executionTime
         *        Time taken to execute this stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTime(Long executionTime);

        /**
         * <p>
         * Stage plan information such as name, identifier, sub plans, and source stages.
         * </p>
         * 
         * @param queryStagePlan
         *        Stage plan information such as name, identifier, sub plans, and source stages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStagePlan(QueryStagePlanNode queryStagePlan);

        /**
         * <p>
         * Stage plan information such as name, identifier, sub plans, and source stages.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryStagePlanNode.Builder} avoiding the
         * need to create one manually via {@link QueryStagePlanNode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryStagePlanNode.Builder#build()} is called immediately and its
         * result is passed to {@link #queryStagePlan(QueryStagePlanNode)}.
         * 
         * @param queryStagePlan
         *        a consumer that will call methods on {@link QueryStagePlanNode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryStagePlan(QueryStagePlanNode)
         */
        default Builder queryStagePlan(Consumer<QueryStagePlanNode.Builder> queryStagePlan) {
            return queryStagePlan(QueryStagePlanNode.builder().applyMutation(queryStagePlan).build());
        }

        /**
         * <p>
         * List of sub query stages that form this stage execution plan.
         * </p>
         * 
         * @param subStages
         *        List of sub query stages that form this stage execution plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subStages(Collection<QueryStage> subStages);

        /**
         * <p>
         * List of sub query stages that form this stage execution plan.
         * </p>
         * 
         * @param subStages
         *        List of sub query stages that form this stage execution plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subStages(QueryStage... subStages);

        /**
         * <p>
         * List of sub query stages that form this stage execution plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.athena.model.QueryStage.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.athena.model.QueryStage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.athena.model.QueryStage.Builder#build()} is called immediately and its
         * result is passed to {@link #subStages(List<QueryStage>)}.
         * 
         * @param subStages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.athena.model.QueryStage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subStages(java.util.Collection<QueryStage>)
         */
        Builder subStages(Consumer<Builder>... subStages);
    }

    static final class BuilderImpl implements Builder {
        private Long stageId;

        private String state;

        private Long outputBytes;

        private Long outputRows;

        private Long inputBytes;

        private Long inputRows;

        private Long executionTime;

        private QueryStagePlanNode queryStagePlan;

        private List<QueryStage> subStages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryStage model) {
            stageId(model.stageId);
            state(model.state);
            outputBytes(model.outputBytes);
            outputRows(model.outputRows);
            inputBytes(model.inputBytes);
            inputRows(model.inputRows);
            executionTime(model.executionTime);
            queryStagePlan(model.queryStagePlan);
            subStages(model.subStages);
        }

        public final Long getStageId() {
            return stageId;
        }

        public final void setStageId(Long stageId) {
            this.stageId = stageId;
        }

        @Override
        public final Builder stageId(Long stageId) {
            this.stageId = stageId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final Long getOutputBytes() {
            return outputBytes;
        }

        public final void setOutputBytes(Long outputBytes) {
            this.outputBytes = outputBytes;
        }

        @Override
        public final Builder outputBytes(Long outputBytes) {
            this.outputBytes = outputBytes;
            return this;
        }

        public final Long getOutputRows() {
            return outputRows;
        }

        public final void setOutputRows(Long outputRows) {
            this.outputRows = outputRows;
        }

        @Override
        public final Builder outputRows(Long outputRows) {
            this.outputRows = outputRows;
            return this;
        }

        public final Long getInputBytes() {
            return inputBytes;
        }

        public final void setInputBytes(Long inputBytes) {
            this.inputBytes = inputBytes;
        }

        @Override
        public final Builder inputBytes(Long inputBytes) {
            this.inputBytes = inputBytes;
            return this;
        }

        public final Long getInputRows() {
            return inputRows;
        }

        public final void setInputRows(Long inputRows) {
            this.inputRows = inputRows;
        }

        @Override
        public final Builder inputRows(Long inputRows) {
            this.inputRows = inputRows;
            return this;
        }

        public final Long getExecutionTime() {
            return executionTime;
        }

        public final void setExecutionTime(Long executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public final Builder executionTime(Long executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final QueryStagePlanNode.Builder getQueryStagePlan() {
            return queryStagePlan != null ? queryStagePlan.toBuilder() : null;
        }

        public final void setQueryStagePlan(QueryStagePlanNode.BuilderImpl queryStagePlan) {
            this.queryStagePlan = queryStagePlan != null ? queryStagePlan.build() : null;
        }

        @Override
        public final Builder queryStagePlan(QueryStagePlanNode queryStagePlan) {
            this.queryStagePlan = queryStagePlan;
            return this;
        }

        public final List<Builder> getSubStages() {
            List<Builder> result = QueryStagesCopier.copyToBuilder(this.subStages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubStages(Collection<BuilderImpl> subStages) {
            this.subStages = QueryStagesCopier.copyFromBuilder(subStages);
        }

        @Override
        public final Builder subStages(Collection<QueryStage> subStages) {
            this.subStages = QueryStagesCopier.copy(subStages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subStages(QueryStage... subStages) {
            subStages(Arrays.asList(subStages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subStages(Consumer<Builder>... subStages) {
            subStages(Stream.of(subStages).map(c -> QueryStage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public QueryStage build() {
            return new QueryStage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
