/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Athena engine version for running queries, or the PySpark engine version for running sessions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngineVersion implements SdkPojo, Serializable, ToCopyableBuilder<EngineVersion.Builder, EngineVersion> {
    private static final SdkField<String> SELECTED_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectedEngineVersion").getter(getter(EngineVersion::selectedEngineVersion))
            .setter(setter(Builder::selectedEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedEngineVersion").build())
            .build();

    private static final SdkField<String> EFFECTIVE_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EffectiveEngineVersion").getter(getter(EngineVersion::effectiveEngineVersion))
            .setter(setter(Builder::effectiveEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveEngineVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_ENGINE_VERSION_FIELD,
            EFFECTIVE_ENGINE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String selectedEngineVersion;

    private final String effectiveEngineVersion;

    private EngineVersion(BuilderImpl builder) {
        this.selectedEngineVersion = builder.selectedEngineVersion;
        this.effectiveEngineVersion = builder.effectiveEngineVersion;
    }

    /**
     * <p>
     * The engine version requested by the user. Possible values are determined by the output of
     * <code>ListEngineVersions</code>, including AUTO. The default is AUTO.
     * </p>
     * 
     * @return The engine version requested by the user. Possible values are determined by the output of
     *         <code>ListEngineVersions</code>, including AUTO. The default is AUTO.
     */
    public final String selectedEngineVersion() {
        return selectedEngineVersion;
    }

    /**
     * <p>
     * Read only. The engine version on which the query runs. If the user requests a valid engine version other than
     * Auto, the effective engine version is the same as the engine version that the user requested. If the user
     * requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is
     * made by a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the
     * <code>EffectiveEngineVersion</code> field is ignored.
     * </p>
     * 
     * @return Read only. The engine version on which the query runs. If the user requests a valid engine version other
     *         than Auto, the effective engine version is the same as the engine version that the user requested. If the
     *         user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine
     *         version is made by a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the
     *         <code>EffectiveEngineVersion</code> field is ignored.
     */
    public final String effectiveEngineVersion() {
        return effectiveEngineVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(selectedEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveEngineVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineVersion)) {
            return false;
        }
        EngineVersion other = (EngineVersion) obj;
        return Objects.equals(selectedEngineVersion(), other.selectedEngineVersion())
                && Objects.equals(effectiveEngineVersion(), other.effectiveEngineVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EngineVersion").add("SelectedEngineVersion", selectedEngineVersion())
                .add("EffectiveEngineVersion", effectiveEngineVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelectedEngineVersion":
            return Optional.ofNullable(clazz.cast(selectedEngineVersion()));
        case "EffectiveEngineVersion":
            return Optional.ofNullable(clazz.cast(effectiveEngineVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SelectedEngineVersion", SELECTED_ENGINE_VERSION_FIELD);
        map.put("EffectiveEngineVersion", EFFECTIVE_ENGINE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngineVersion, T> g) {
        return obj -> g.apply((EngineVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngineVersion> {
        /**
         * <p>
         * The engine version requested by the user. Possible values are determined by the output of
         * <code>ListEngineVersions</code>, including AUTO. The default is AUTO.
         * </p>
         * 
         * @param selectedEngineVersion
         *        The engine version requested by the user. Possible values are determined by the output of
         *        <code>ListEngineVersions</code>, including AUTO. The default is AUTO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedEngineVersion(String selectedEngineVersion);

        /**
         * <p>
         * Read only. The engine version on which the query runs. If the user requests a valid engine version other than
         * Auto, the effective engine version is the same as the engine version that the user requested. If the user
         * requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version
         * is made by a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the
         * <code>EffectiveEngineVersion</code> field is ignored.
         * </p>
         * 
         * @param effectiveEngineVersion
         *        Read only. The engine version on which the query runs. If the user requests a valid engine version
         *        other than Auto, the effective engine version is the same as the engine version that the user
         *        requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request
         *        to update the engine version is made by a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code>
         *        operation, the <code>EffectiveEngineVersion</code> field is ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveEngineVersion(String effectiveEngineVersion);
    }

    static final class BuilderImpl implements Builder {
        private String selectedEngineVersion;

        private String effectiveEngineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(EngineVersion model) {
            selectedEngineVersion(model.selectedEngineVersion);
            effectiveEngineVersion(model.effectiveEngineVersion);
        }

        public final String getSelectedEngineVersion() {
            return selectedEngineVersion;
        }

        public final void setSelectedEngineVersion(String selectedEngineVersion) {
            this.selectedEngineVersion = selectedEngineVersion;
        }

        @Override
        public final Builder selectedEngineVersion(String selectedEngineVersion) {
            this.selectedEngineVersion = selectedEngineVersion;
            return this;
        }

        public final String getEffectiveEngineVersion() {
            return effectiveEngineVersion;
        }

        public final void setEffectiveEngineVersion(String effectiveEngineVersion) {
            this.effectiveEngineVersion = effectiveEngineVersion;
        }

        @Override
        public final Builder effectiveEngineVersion(String effectiveEngineVersion) {
            this.effectiveEngineVersion = effectiveEngineVersion;
            return this;
        }

        @Override
        public EngineVersion build() {
            return new EngineVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
