/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCalculationExecutionResponse extends AthenaResponse implements
        ToCopyableBuilder<StartCalculationExecutionResponse.Builder, StartCalculationExecutionResponse> {
    private static final SdkField<String> CALCULATION_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CalculationExecutionId").getter(getter(StartCalculationExecutionResponse::calculationExecutionId))
            .setter(setter(Builder::calculationExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculationExecutionId").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(StartCalculationExecutionResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CALCULATION_EXECUTION_ID_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String calculationExecutionId;

    private final String state;

    private StartCalculationExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.calculationExecutionId = builder.calculationExecutionId;
        this.state = builder.state;
    }

    /**
     * <p>
     * The calculation execution UUID.
     * </p>
     * 
     * @return The calculation execution UUID.
     */
    public final String calculationExecutionId() {
        return calculationExecutionId;
    }

    /**
     * <p>
     * <code>CREATING</code> - The calculation is in the process of being created.
     * </p>
     * <p>
     * <code>CREATED</code> - The calculation has been created and is ready to run.
     * </p>
     * <p>
     * <code>QUEUED</code> - The calculation has been queued for processing.
     * </p>
     * <p>
     * <code>RUNNING</code> - The calculation is running.
     * </p>
     * <p>
     * <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to stop
     * it.
     * </p>
     * <p>
     * <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     * </p>
     * <p>
     * <code>COMPLETED</code> - The calculation has completed without error.
     * </p>
     * <p>
     * <code>FAILED</code> - The calculation failed and is no longer running.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CalculationExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <code>CREATING</code> - The calculation is in the process of being created.</p>
     *         <p>
     *         <code>CREATED</code> - The calculation has been created and is ready to run.
     *         </p>
     *         <p>
     *         <code>QUEUED</code> - The calculation has been queued for processing.
     *         </p>
     *         <p>
     *         <code>RUNNING</code> - The calculation is running.
     *         </p>
     *         <p>
     *         <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working
     *         to stop it.
     *         </p>
     *         <p>
     *         <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     *         </p>
     *         <p>
     *         <code>COMPLETED</code> - The calculation has completed without error.
     *         </p>
     *         <p>
     *         <code>FAILED</code> - The calculation failed and is no longer running.
     * @see CalculationExecutionState
     */
    public final CalculationExecutionState state() {
        return CalculationExecutionState.fromValue(state);
    }

    /**
     * <p>
     * <code>CREATING</code> - The calculation is in the process of being created.
     * </p>
     * <p>
     * <code>CREATED</code> - The calculation has been created and is ready to run.
     * </p>
     * <p>
     * <code>QUEUED</code> - The calculation has been queued for processing.
     * </p>
     * <p>
     * <code>RUNNING</code> - The calculation is running.
     * </p>
     * <p>
     * <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to stop
     * it.
     * </p>
     * <p>
     * <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     * </p>
     * <p>
     * <code>COMPLETED</code> - The calculation has completed without error.
     * </p>
     * <p>
     * <code>FAILED</code> - The calculation failed and is no longer running.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CalculationExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <code>CREATING</code> - The calculation is in the process of being created.</p>
     *         <p>
     *         <code>CREATED</code> - The calculation has been created and is ready to run.
     *         </p>
     *         <p>
     *         <code>QUEUED</code> - The calculation has been queued for processing.
     *         </p>
     *         <p>
     *         <code>RUNNING</code> - The calculation is running.
     *         </p>
     *         <p>
     *         <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working
     *         to stop it.
     *         </p>
     *         <p>
     *         <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     *         </p>
     *         <p>
     *         <code>COMPLETED</code> - The calculation has completed without error.
     *         </p>
     *         <p>
     *         <code>FAILED</code> - The calculation failed and is no longer running.
     * @see CalculationExecutionState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(calculationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCalculationExecutionResponse)) {
            return false;
        }
        StartCalculationExecutionResponse other = (StartCalculationExecutionResponse) obj;
        return Objects.equals(calculationExecutionId(), other.calculationExecutionId())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCalculationExecutionResponse").add("CalculationExecutionId", calculationExecutionId())
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CalculationExecutionId":
            return Optional.ofNullable(clazz.cast(calculationExecutionId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CalculationExecutionId", CALCULATION_EXECUTION_ID_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCalculationExecutionResponse, T> g) {
        return obj -> g.apply((StartCalculationExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartCalculationExecutionResponse> {
        /**
         * <p>
         * The calculation execution UUID.
         * </p>
         * 
         * @param calculationExecutionId
         *        The calculation execution UUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculationExecutionId(String calculationExecutionId);

        /**
         * <p>
         * <code>CREATING</code> - The calculation is in the process of being created.
         * </p>
         * <p>
         * <code>CREATED</code> - The calculation has been created and is ready to run.
         * </p>
         * <p>
         * <code>QUEUED</code> - The calculation has been queued for processing.
         * </p>
         * <p>
         * <code>RUNNING</code> - The calculation is running.
         * </p>
         * <p>
         * <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to
         * stop it.
         * </p>
         * <p>
         * <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
         * </p>
         * <p>
         * <code>COMPLETED</code> - The calculation has completed without error.
         * </p>
         * <p>
         * <code>FAILED</code> - The calculation failed and is no longer running.
         * </p>
         * 
         * @param state
         *        <code>CREATING</code> - The calculation is in the process of being created.</p>
         *        <p>
         *        <code>CREATED</code> - The calculation has been created and is ready to run.
         *        </p>
         *        <p>
         *        <code>QUEUED</code> - The calculation has been queued for processing.
         *        </p>
         *        <p>
         *        <code>RUNNING</code> - The calculation is running.
         *        </p>
         *        <p>
         *        <code>CANCELING</code> - A request to cancel the calculation has been received and the system is
         *        working to stop it.
         *        </p>
         *        <p>
         *        <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
         *        </p>
         *        <p>
         *        <code>COMPLETED</code> - The calculation has completed without error.
         *        </p>
         *        <p>
         *        <code>FAILED</code> - The calculation failed and is no longer running.
         * @see CalculationExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CalculationExecutionState
         */
        Builder state(String state);

        /**
         * <p>
         * <code>CREATING</code> - The calculation is in the process of being created.
         * </p>
         * <p>
         * <code>CREATED</code> - The calculation has been created and is ready to run.
         * </p>
         * <p>
         * <code>QUEUED</code> - The calculation has been queued for processing.
         * </p>
         * <p>
         * <code>RUNNING</code> - The calculation is running.
         * </p>
         * <p>
         * <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to
         * stop it.
         * </p>
         * <p>
         * <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
         * </p>
         * <p>
         * <code>COMPLETED</code> - The calculation has completed without error.
         * </p>
         * <p>
         * <code>FAILED</code> - The calculation failed and is no longer running.
         * </p>
         * 
         * @param state
         *        <code>CREATING</code> - The calculation is in the process of being created.</p>
         *        <p>
         *        <code>CREATED</code> - The calculation has been created and is ready to run.
         *        </p>
         *        <p>
         *        <code>QUEUED</code> - The calculation has been queued for processing.
         *        </p>
         *        <p>
         *        <code>RUNNING</code> - The calculation is running.
         *        </p>
         *        <p>
         *        <code>CANCELING</code> - A request to cancel the calculation has been received and the system is
         *        working to stop it.
         *        </p>
         *        <p>
         *        <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
         *        </p>
         *        <p>
         *        <code>COMPLETED</code> - The calculation has completed without error.
         *        </p>
         *        <p>
         *        <code>FAILED</code> - The calculation failed and is no longer running.
         * @see CalculationExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CalculationExecutionState
         */
        Builder state(CalculationExecutionState state);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private String calculationExecutionId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCalculationExecutionResponse model) {
            super(model);
            calculationExecutionId(model.calculationExecutionId);
            state(model.state);
        }

        public final String getCalculationExecutionId() {
            return calculationExecutionId;
        }

        public final void setCalculationExecutionId(String calculationExecutionId) {
            this.calculationExecutionId = calculationExecutionId;
        }

        @Override
        public final Builder calculationExecutionId(String calculationExecutionId) {
            this.calculationExecutionId = calculationExecutionId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CalculationExecutionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public StartCalculationExecutionResponse build() {
            return new StartCalculationExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
