/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTableMetadataRequest extends AthenaRequest implements
        ToCopyableBuilder<GetTableMetadataRequest.Builder, GetTableMetadataRequest> {
    private static final SdkField<String> CATALOG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogName").getter(getter(GetTableMetadataRequest::catalogName)).setter(setter(Builder::catalogName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogName").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(GetTableMetadataRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(GetTableMetadataRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkGroup").getter(getter(GetTableMetadataRequest::workGroup)).setter(setter(Builder::workGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_NAME_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD, WORK_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalogName;

    private final String databaseName;

    private final String tableName;

    private final String workGroup;

    private GetTableMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.catalogName = builder.catalogName;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.workGroup = builder.workGroup;
    }

    /**
     * <p>
     * The name of the data catalog that contains the database and table metadata to return.
     * </p>
     * 
     * @return The name of the data catalog that contains the database and table metadata to return.
     */
    public final String catalogName() {
        return catalogName;
    }

    /**
     * <p>
     * The name of the database that contains the table metadata to return.
     * </p>
     * 
     * @return The name of the database that contains the table metadata to return.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the table for which metadata is returned.
     * </p>
     * 
     * @return The name of the table for which metadata is returned.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The name of the workgroup for which the metadata is being fetched. Required if requesting an IAM Identity Center
     * enabled Glue Data Catalog.
     * </p>
     * 
     * @return The name of the workgroup for which the metadata is being fetched. Required if requesting an IAM Identity
     *         Center enabled Glue Data Catalog.
     */
    public final String workGroup() {
        return workGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(workGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableMetadataRequest)) {
            return false;
        }
        GetTableMetadataRequest other = (GetTableMetadataRequest) obj;
        return Objects.equals(catalogName(), other.catalogName()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(workGroup(), other.workGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTableMetadataRequest").add("CatalogName", catalogName()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("WorkGroup", workGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogName":
            return Optional.ofNullable(clazz.cast(catalogName()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "WorkGroup":
            return Optional.ofNullable(clazz.cast(workGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CatalogName", CATALOG_NAME_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("WorkGroup", WORK_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTableMetadataRequest, T> g) {
        return obj -> g.apply((GetTableMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTableMetadataRequest> {
        /**
         * <p>
         * The name of the data catalog that contains the database and table metadata to return.
         * </p>
         * 
         * @param catalogName
         *        The name of the data catalog that contains the database and table metadata to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogName(String catalogName);

        /**
         * <p>
         * The name of the database that contains the table metadata to return.
         * </p>
         * 
         * @param databaseName
         *        The name of the database that contains the table metadata to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the table for which metadata is returned.
         * </p>
         * 
         * @param tableName
         *        The name of the table for which metadata is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The name of the workgroup for which the metadata is being fetched. Required if requesting an IAM Identity
         * Center enabled Glue Data Catalog.
         * </p>
         * 
         * @param workGroup
         *        The name of the workgroup for which the metadata is being fetched. Required if requesting an IAM
         *        Identity Center enabled Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroup(String workGroup);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private String catalogName;

        private String databaseName;

        private String tableName;

        private String workGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableMetadataRequest model) {
            super(model);
            catalogName(model.catalogName);
            databaseName(model.databaseName);
            tableName(model.tableName);
            workGroup(model.workGroup);
        }

        public final String getCatalogName() {
            return catalogName;
        }

        public final void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        @Override
        public final Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getWorkGroup() {
            return workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTableMetadataRequest build() {
            return new GetTableMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
