/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectionType {
    DYNAMODB("DYNAMODB"),
    MYSQL("MYSQL"),
    POSTGRESQL("POSTGRESQL"),
    REDSHIFT("REDSHIFT"),
    ORACLE("ORACLE"),
    SYNAPSE("SYNAPSE"),
    SQLSERVER("SQLSERVER"),
    DB2("DB2"),
    OPENSEARCH("OPENSEARCH"),
    BIGQUERY("BIGQUERY"),
    GOOGLECLOUDSTORAGE("GOOGLECLOUDSTORAGE"),
    HBASE("HBASE"),
    DOCUMENTDB("DOCUMENTDB"),
    CMDB("CMDB"),
    TPCDS("TPCDS"),
    TIMESTREAM("TIMESTREAM"),
    SAPHANA("SAPHANA"),
    SNOWFLAKE("SNOWFLAKE"),
    DATALAKEGEN2("DATALAKEGEN2"),
    DB2_AS400("DB2AS400"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectionType> VALUE_MAP;
    private final String value;

    private ConnectionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectionType> knownValues() {
        EnumSet<ConnectionType> knownValues = EnumSet.allOf(ConnectionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectionType.class, ConnectionType::toString);
    }
}

