/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotebookSessionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotebookSessionSummary> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(NotebookSessionSummary.getter(NotebookSessionSummary::sessionId)).setter(NotebookSessionSummary.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(NotebookSessionSummary.getter(NotebookSessionSummary::creationTime)).setter(NotebookSessionSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SessionId", SESSION_ID_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private final Instant creationTime;

    private NotebookSessionSummary(BuilderImpl builder) {
        this.sessionId = builder.sessionId;
        this.creationTime = builder.creationTime;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotebookSessionSummary)) {
            return false;
        }
        NotebookSessionSummary other = (NotebookSessionSummary)obj;
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"NotebookSessionSummary").add("SessionId", (Object)this.sessionId()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NotebookSessionSummary, T> g) {
        return obj -> g.apply((NotebookSessionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sessionId;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(NotebookSessionSummary model) {
            this.sessionId(model.sessionId);
            this.creationTime(model.creationTime);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public NotebookSessionSummary build() {
            return new NotebookSessionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotebookSessionSummary> {
        public Builder sessionId(String var1);

        public Builder creationTime(Instant var1);
    }
}

