/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNamedQueryRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, CreateNamedQueryRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateNamedQueryRequest.getter(CreateNamedQueryRequest::name)).setter(CreateNamedQueryRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateNamedQueryRequest.getter(CreateNamedQueryRequest::description)).setter(CreateNamedQueryRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(CreateNamedQueryRequest.getter(CreateNamedQueryRequest::database)).setter(CreateNamedQueryRequest.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryString").getter(CreateNamedQueryRequest.getter(CreateNamedQueryRequest::queryString)).setter(CreateNamedQueryRequest.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateNamedQueryRequest.getter(CreateNamedQueryRequest::clientRequestToken)).setter(CreateNamedQueryRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkGroup").getter(CreateNamedQueryRequest.getter(CreateNamedQueryRequest::workGroup)).setter(CreateNamedQueryRequest.setter(Builder::workGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, DATABASE_FIELD, QUERY_STRING_FIELD, CLIENT_REQUEST_TOKEN_FIELD, WORK_GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Database", DATABASE_FIELD);
            this.put("QueryString", QUERY_STRING_FIELD);
            this.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("WorkGroup", WORK_GROUP_FIELD);
        }
    });
    private final String name;
    private final String description;
    private final String database;
    private final String queryString;
    private final String clientRequestToken;
    private final String workGroup;

    private CreateNamedQueryRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.database = builder.database;
        this.queryString = builder.queryString;
        this.clientRequestToken = builder.clientRequestToken;
        this.workGroup = builder.workGroup;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String database() {
        return this.database;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String workGroup() {
        return this.workGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNamedQueryRequest)) {
            return false;
        }
        CreateNamedQueryRequest other = (CreateNamedQueryRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.workGroup(), other.workGroup());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNamedQueryRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Database", (Object)this.database()).add("QueryString", (Object)this.queryString()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("WorkGroup", (Object)this.workGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "WorkGroup": {
                return Optional.ofNullable(clazz.cast(this.workGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateNamedQueryRequest, T> g) {
        return obj -> g.apply((CreateNamedQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String database;
        private String queryString;
        private String clientRequestToken;
        private String workGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNamedQueryRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.database(model.database);
            this.queryString(model.queryString);
            this.clientRequestToken(model.clientRequestToken);
            this.workGroup(model.workGroup);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getWorkGroup() {
            return this.workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNamedQueryRequest build() {
            return new CreateNamedQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNamedQueryRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder database(String var1);

        public Builder queryString(String var1);

        public Builder clientRequestToken(String var1);

        public Builder workGroup(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

