/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EngineVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EngineVersion> {
    private static final SdkField<String> SELECTED_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectedEngineVersion").getter(EngineVersion.getter(EngineVersion::selectedEngineVersion)).setter(EngineVersion.setter(Builder::selectedEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedEngineVersion").build()}).build();
    private static final SdkField<String> EFFECTIVE_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EffectiveEngineVersion").getter(EngineVersion.getter(EngineVersion::effectiveEngineVersion)).setter(EngineVersion.setter(Builder::effectiveEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveEngineVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_ENGINE_VERSION_FIELD, EFFECTIVE_ENGINE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SelectedEngineVersion", SELECTED_ENGINE_VERSION_FIELD);
            this.put("EffectiveEngineVersion", EFFECTIVE_ENGINE_VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String selectedEngineVersion;
    private final String effectiveEngineVersion;

    private EngineVersion(BuilderImpl builder) {
        this.selectedEngineVersion = builder.selectedEngineVersion;
        this.effectiveEngineVersion = builder.effectiveEngineVersion;
    }

    public final String selectedEngineVersion() {
        return this.selectedEngineVersion;
    }

    public final String effectiveEngineVersion() {
        return this.effectiveEngineVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.selectedEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveEngineVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineVersion)) {
            return false;
        }
        EngineVersion other = (EngineVersion)obj;
        return Objects.equals(this.selectedEngineVersion(), other.selectedEngineVersion()) && Objects.equals(this.effectiveEngineVersion(), other.effectiveEngineVersion());
    }

    public final String toString() {
        return ToString.builder((String)"EngineVersion").add("SelectedEngineVersion", (Object)this.selectedEngineVersion()).add("EffectiveEngineVersion", (Object)this.effectiveEngineVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SelectedEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.selectedEngineVersion()));
            }
            case "EffectiveEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.effectiveEngineVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EngineVersion, T> g) {
        return obj -> g.apply((EngineVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String selectedEngineVersion;
        private String effectiveEngineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(EngineVersion model) {
            this.selectedEngineVersion(model.selectedEngineVersion);
            this.effectiveEngineVersion(model.effectiveEngineVersion);
        }

        public final String getSelectedEngineVersion() {
            return this.selectedEngineVersion;
        }

        public final void setSelectedEngineVersion(String selectedEngineVersion) {
            this.selectedEngineVersion = selectedEngineVersion;
        }

        @Override
        public final Builder selectedEngineVersion(String selectedEngineVersion) {
            this.selectedEngineVersion = selectedEngineVersion;
            return this;
        }

        public final String getEffectiveEngineVersion() {
            return this.effectiveEngineVersion;
        }

        public final void setEffectiveEngineVersion(String effectiveEngineVersion) {
            this.effectiveEngineVersion = effectiveEngineVersion;
        }

        @Override
        public final Builder effectiveEngineVersion(String effectiveEngineVersion) {
            this.effectiveEngineVersion = effectiveEngineVersion;
            return this;
        }

        public EngineVersion build() {
            return new EngineVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EngineVersion> {
        public Builder selectedEngineVersion(String var1);

        public Builder effectiveEngineVersion(String var1);
    }
}

