/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.CalculationExecutionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCalculationExecutionResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, StartCalculationExecutionResponse> {
    private static final SdkField<String> CALCULATION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculationExecutionId").getter(StartCalculationExecutionResponse.getter(StartCalculationExecutionResponse::calculationExecutionId)).setter(StartCalculationExecutionResponse.setter(Builder::calculationExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculationExecutionId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(StartCalculationExecutionResponse.getter(StartCalculationExecutionResponse::stateAsString)).setter(StartCalculationExecutionResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATION_EXECUTION_ID_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CalculationExecutionId", CALCULATION_EXECUTION_ID_FIELD);
            this.put("State", STATE_FIELD);
        }
    });
    private final String calculationExecutionId;
    private final String state;

    private StartCalculationExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.calculationExecutionId = builder.calculationExecutionId;
        this.state = builder.state;
    }

    public final String calculationExecutionId() {
        return this.calculationExecutionId;
    }

    public final CalculationExecutionState state() {
        return CalculationExecutionState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.calculationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCalculationExecutionResponse)) {
            return false;
        }
        StartCalculationExecutionResponse other = (StartCalculationExecutionResponse)((Object)obj);
        return Objects.equals(this.calculationExecutionId(), other.calculationExecutionId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartCalculationExecutionResponse").add("CalculationExecutionId", (Object)this.calculationExecutionId()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CalculationExecutionId": {
                return Optional.ofNullable(clazz.cast(this.calculationExecutionId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartCalculationExecutionResponse, T> g) {
        return obj -> g.apply((StartCalculationExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private String calculationExecutionId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCalculationExecutionResponse model) {
            super(model);
            this.calculationExecutionId(model.calculationExecutionId);
            this.state(model.state);
        }

        public final String getCalculationExecutionId() {
            return this.calculationExecutionId;
        }

        public final void setCalculationExecutionId(String calculationExecutionId) {
            this.calculationExecutionId = calculationExecutionId;
        }

        @Override
        public final Builder calculationExecutionId(String calculationExecutionId) {
            this.calculationExecutionId = calculationExecutionId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CalculationExecutionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public StartCalculationExecutionResponse build() {
            return new StartCalculationExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartCalculationExecutionResponse> {
        public Builder calculationExecutionId(String var1);

        public Builder state(String var1);

        public Builder state(CalculationExecutionState var1);
    }
}

