/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AuthenticationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryResultsS3AccessGrantsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryResultsS3AccessGrantsConfiguration> {
    private static final SdkField<Boolean> ENABLE_S3_ACCESS_GRANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableS3AccessGrants").getter(QueryResultsS3AccessGrantsConfiguration.getter(QueryResultsS3AccessGrantsConfiguration::enableS3AccessGrants)).setter(QueryResultsS3AccessGrantsConfiguration.setter(Builder::enableS3AccessGrants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableS3AccessGrants").build()}).build();
    private static final SdkField<Boolean> CREATE_USER_LEVEL_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CreateUserLevelPrefix").getter(QueryResultsS3AccessGrantsConfiguration.getter(QueryResultsS3AccessGrantsConfiguration::createUserLevelPrefix)).setter(QueryResultsS3AccessGrantsConfiguration.setter(Builder::createUserLevelPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateUserLevelPrefix").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationType").getter(QueryResultsS3AccessGrantsConfiguration.getter(QueryResultsS3AccessGrantsConfiguration::authenticationTypeAsString)).setter(QueryResultsS3AccessGrantsConfiguration.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_S3_ACCESS_GRANTS_FIELD, CREATE_USER_LEVEL_PREFIX_FIELD, AUTHENTICATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EnableS3AccessGrants", ENABLE_S3_ACCESS_GRANTS_FIELD);
            this.put("CreateUserLevelPrefix", CREATE_USER_LEVEL_PREFIX_FIELD);
            this.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean enableS3AccessGrants;
    private final Boolean createUserLevelPrefix;
    private final String authenticationType;

    private QueryResultsS3AccessGrantsConfiguration(BuilderImpl builder) {
        this.enableS3AccessGrants = builder.enableS3AccessGrants;
        this.createUserLevelPrefix = builder.createUserLevelPrefix;
        this.authenticationType = builder.authenticationType;
    }

    public final Boolean enableS3AccessGrants() {
        return this.enableS3AccessGrants;
    }

    public final Boolean createUserLevelPrefix() {
        return this.createUserLevelPrefix;
    }

    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableS3AccessGrants());
        hashCode = 31 * hashCode + Objects.hashCode(this.createUserLevelPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResultsS3AccessGrantsConfiguration)) {
            return false;
        }
        QueryResultsS3AccessGrantsConfiguration other = (QueryResultsS3AccessGrantsConfiguration)obj;
        return Objects.equals(this.enableS3AccessGrants(), other.enableS3AccessGrants()) && Objects.equals(this.createUserLevelPrefix(), other.createUserLevelPrefix()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"QueryResultsS3AccessGrantsConfiguration").add("EnableS3AccessGrants", (Object)this.enableS3AccessGrants()).add("CreateUserLevelPrefix", (Object)this.createUserLevelPrefix()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableS3AccessGrants": {
                return Optional.ofNullable(clazz.cast(this.enableS3AccessGrants()));
            }
            case "CreateUserLevelPrefix": {
                return Optional.ofNullable(clazz.cast(this.createUserLevelPrefix()));
            }
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QueryResultsS3AccessGrantsConfiguration, T> g) {
        return obj -> g.apply((QueryResultsS3AccessGrantsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enableS3AccessGrants;
        private Boolean createUserLevelPrefix;
        private String authenticationType;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResultsS3AccessGrantsConfiguration model) {
            this.enableS3AccessGrants(model.enableS3AccessGrants);
            this.createUserLevelPrefix(model.createUserLevelPrefix);
            this.authenticationType(model.authenticationType);
        }

        public final Boolean getEnableS3AccessGrants() {
            return this.enableS3AccessGrants;
        }

        public final void setEnableS3AccessGrants(Boolean enableS3AccessGrants) {
            this.enableS3AccessGrants = enableS3AccessGrants;
        }

        @Override
        public final Builder enableS3AccessGrants(Boolean enableS3AccessGrants) {
            this.enableS3AccessGrants = enableS3AccessGrants;
            return this;
        }

        public final Boolean getCreateUserLevelPrefix() {
            return this.createUserLevelPrefix;
        }

        public final void setCreateUserLevelPrefix(Boolean createUserLevelPrefix) {
            this.createUserLevelPrefix = createUserLevelPrefix;
        }

        @Override
        public final Builder createUserLevelPrefix(Boolean createUserLevelPrefix) {
            this.createUserLevelPrefix = createUserLevelPrefix;
            return this;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public QueryResultsS3AccessGrantsConfiguration build() {
            return new QueryResultsS3AccessGrantsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryResultsS3AccessGrantsConfiguration> {
        public Builder enableS3AccessGrants(Boolean var1);

        public Builder createUserLevelPrefix(Boolean var1);

        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);
    }
}

