/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.athena.model.Column;
import software.amazon.awssdk.services.athena.model.ColumnListCopier;
import software.amazon.awssdk.services.athena.model.ParametersMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableMetadata> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TableMetadata.getter(TableMetadata::name)).setter(TableMetadata.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(TableMetadata.getter(TableMetadata::createTime)).setter(TableMetadata.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<Instant> LAST_ACCESS_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastAccessTime").getter(TableMetadata.getter(TableMetadata::lastAccessTime)).setter(TableMetadata.setter(Builder::lastAccessTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessTime").build()}).build();
    private static final SdkField<String> TABLE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableType").getter(TableMetadata.getter(TableMetadata::tableType)).setter(TableMetadata.setter(Builder::tableType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableType").build()}).build();
    private static final SdkField<List<Column>> COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Columns").getter(TableMetadata.getter(TableMetadata::columns)).setter(TableMetadata.setter(Builder::columns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Column::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Column>> PARTITION_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionKeys").getter(TableMetadata.getter(TableMetadata::partitionKeys)).setter(TableMetadata.setter(Builder::partitionKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Column::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(TableMetadata.getter(TableMetadata::parameters)).setter(TableMetadata.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CREATE_TIME_FIELD, LAST_ACCESS_TIME_FIELD, TABLE_TYPE_FIELD, COLUMNS_FIELD, PARTITION_KEYS_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("CreateTime", CREATE_TIME_FIELD);
            this.put("LastAccessTime", LAST_ACCESS_TIME_FIELD);
            this.put("TableType", TABLE_TYPE_FIELD);
            this.put("Columns", COLUMNS_FIELD);
            this.put("PartitionKeys", PARTITION_KEYS_FIELD);
            this.put("Parameters", PARAMETERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Instant createTime;
    private final Instant lastAccessTime;
    private final String tableType;
    private final List<Column> columns;
    private final List<Column> partitionKeys;
    private final Map<String, String> parameters;

    private TableMetadata(BuilderImpl builder) {
        this.name = builder.name;
        this.createTime = builder.createTime;
        this.lastAccessTime = builder.lastAccessTime;
        this.tableType = builder.tableType;
        this.columns = builder.columns;
        this.partitionKeys = builder.partitionKeys;
        this.parameters = builder.parameters;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant lastAccessTime() {
        return this.lastAccessTime;
    }

    public final String tableType() {
        return this.tableType;
    }

    public final boolean hasColumns() {
        return this.columns != null && !(this.columns instanceof SdkAutoConstructList);
    }

    public final List<Column> columns() {
        return this.columns;
    }

    public final boolean hasPartitionKeys() {
        return this.partitionKeys != null && !(this.partitionKeys instanceof SdkAutoConstructList);
    }

    public final List<Column> partitionKeys() {
        return this.partitionKeys;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAccessTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumns() ? this.columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionKeys() ? this.partitionKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableMetadata)) {
            return false;
        }
        TableMetadata other = (TableMetadata)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.lastAccessTime(), other.lastAccessTime()) && Objects.equals(this.tableType(), other.tableType()) && this.hasColumns() == other.hasColumns() && Objects.equals(this.columns(), other.columns()) && this.hasPartitionKeys() == other.hasPartitionKeys() && Objects.equals(this.partitionKeys(), other.partitionKeys()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"TableMetadata").add("Name", (Object)this.name()).add("CreateTime", (Object)this.createTime()).add("LastAccessTime", (Object)this.lastAccessTime()).add("TableType", (Object)this.tableType()).add("Columns", this.hasColumns() ? this.columns() : null).add("PartitionKeys", this.hasPartitionKeys() ? this.partitionKeys() : null).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "LastAccessTime": {
                return Optional.ofNullable(clazz.cast(this.lastAccessTime()));
            }
            case "TableType": {
                return Optional.ofNullable(clazz.cast(this.tableType()));
            }
            case "Columns": {
                return Optional.ofNullable(clazz.cast(this.columns()));
            }
            case "PartitionKeys": {
                return Optional.ofNullable(clazz.cast(this.partitionKeys()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableMetadata, T> g) {
        return obj -> g.apply((TableMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Instant createTime;
        private Instant lastAccessTime;
        private String tableType;
        private List<Column> columns = DefaultSdkAutoConstructList.getInstance();
        private List<Column> partitionKeys = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TableMetadata model) {
            this.name(model.name);
            this.createTime(model.createTime);
            this.lastAccessTime(model.lastAccessTime);
            this.tableType(model.tableType);
            this.columns(model.columns);
            this.partitionKeys(model.partitionKeys);
            this.parameters(model.parameters);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getLastAccessTime() {
            return this.lastAccessTime;
        }

        public final void setLastAccessTime(Instant lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
        }

        @Override
        public final Builder lastAccessTime(Instant lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
            return this;
        }

        public final String getTableType() {
            return this.tableType;
        }

        public final void setTableType(String tableType) {
            this.tableType = tableType;
        }

        @Override
        public final Builder tableType(String tableType) {
            this.tableType = tableType;
            return this;
        }

        public final List<Column.Builder> getColumns() {
            List<Column.Builder> result = ColumnListCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<Column.BuilderImpl> columns) {
            this.columns = ColumnListCopier.copyFromBuilder(columns);
        }

        @Override
        public final Builder columns(Collection<Column> columns) {
            this.columns = ColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Column ... columns) {
            this.columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<Column.Builder> ... columns) {
            this.columns(Stream.of(columns).map(c -> (Column)((Column.Builder)Column.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Column.Builder> getPartitionKeys() {
            List<Column.Builder> result = ColumnListCopier.copyToBuilder(this.partitionKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartitionKeys(Collection<Column.BuilderImpl> partitionKeys) {
            this.partitionKeys = ColumnListCopier.copyFromBuilder(partitionKeys);
        }

        @Override
        public final Builder partitionKeys(Collection<Column> partitionKeys) {
            this.partitionKeys = ColumnListCopier.copy(partitionKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Column ... partitionKeys) {
            this.partitionKeys(Arrays.asList(partitionKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Consumer<Column.Builder> ... partitionKeys) {
            this.partitionKeys(Stream.of(partitionKeys).map(c -> (Column)((Column.Builder)Column.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public TableMetadata build() {
            return new TableMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableMetadata> {
        public Builder name(String var1);

        public Builder createTime(Instant var1);

        public Builder lastAccessTime(Instant var1);

        public Builder tableType(String var1);

        public Builder columns(Collection<Column> var1);

        public Builder columns(Column ... var1);

        public Builder columns(Consumer<Column.Builder> ... var1);

        public Builder partitionKeys(Collection<Column> var1);

        public Builder partitionKeys(Column ... var1);

        public Builder partitionKeys(Consumer<Column.Builder> ... var1);

        public Builder parameters(Map<String, String> var1);
    }
}

