/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.ExecutionParametersCopier;
import software.amazon.awssdk.services.athena.model.QueryExecutionContext;
import software.amazon.awssdk.services.athena.model.ResultConfiguration;
import software.amazon.awssdk.services.athena.model.ResultReuseConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartQueryExecutionRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, StartQueryExecutionRequest> {
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryString").getter(StartQueryExecutionRequest.getter(StartQueryExecutionRequest::queryString)).setter(StartQueryExecutionRequest.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StartQueryExecutionRequest.getter(StartQueryExecutionRequest::clientRequestToken)).setter(StartQueryExecutionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<QueryExecutionContext> QUERY_EXECUTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryExecutionContext").getter(StartQueryExecutionRequest.getter(StartQueryExecutionRequest::queryExecutionContext)).setter(StartQueryExecutionRequest.setter(Builder::queryExecutionContext)).constructor(QueryExecutionContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryExecutionContext").build()}).build();
    private static final SdkField<ResultConfiguration> RESULT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResultConfiguration").getter(StartQueryExecutionRequest.getter(StartQueryExecutionRequest::resultConfiguration)).setter(StartQueryExecutionRequest.setter(Builder::resultConfiguration)).constructor(ResultConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultConfiguration").build()}).build();
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkGroup").getter(StartQueryExecutionRequest.getter(StartQueryExecutionRequest::workGroup)).setter(StartQueryExecutionRequest.setter(Builder::workGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()}).build();
    private static final SdkField<List<String>> EXECUTION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExecutionParameters").getter(StartQueryExecutionRequest.getter(StartQueryExecutionRequest::executionParameters)).setter(StartQueryExecutionRequest.setter(Builder::executionParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ResultReuseConfiguration> RESULT_REUSE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResultReuseConfiguration").getter(StartQueryExecutionRequest.getter(StartQueryExecutionRequest::resultReuseConfiguration)).setter(StartQueryExecutionRequest.setter(Builder::resultReuseConfiguration)).constructor(ResultReuseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultReuseConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STRING_FIELD, CLIENT_REQUEST_TOKEN_FIELD, QUERY_EXECUTION_CONTEXT_FIELD, RESULT_CONFIGURATION_FIELD, WORK_GROUP_FIELD, EXECUTION_PARAMETERS_FIELD, RESULT_REUSE_CONFIGURATION_FIELD));
    private final String queryString;
    private final String clientRequestToken;
    private final QueryExecutionContext queryExecutionContext;
    private final ResultConfiguration resultConfiguration;
    private final String workGroup;
    private final List<String> executionParameters;
    private final ResultReuseConfiguration resultReuseConfiguration;

    private StartQueryExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.queryString = builder.queryString;
        this.clientRequestToken = builder.clientRequestToken;
        this.queryExecutionContext = builder.queryExecutionContext;
        this.resultConfiguration = builder.resultConfiguration;
        this.workGroup = builder.workGroup;
        this.executionParameters = builder.executionParameters;
        this.resultReuseConfiguration = builder.resultReuseConfiguration;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final QueryExecutionContext queryExecutionContext() {
        return this.queryExecutionContext;
    }

    public final ResultConfiguration resultConfiguration() {
        return this.resultConfiguration;
    }

    public final String workGroup() {
        return this.workGroup;
    }

    public final boolean hasExecutionParameters() {
        return this.executionParameters != null && !(this.executionParameters instanceof SdkAutoConstructList);
    }

    public final List<String> executionParameters() {
        return this.executionParameters;
    }

    public final ResultReuseConfiguration resultReuseConfiguration() {
        return this.resultReuseConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryExecutionContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutionParameters() ? this.executionParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resultReuseConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQueryExecutionRequest)) {
            return false;
        }
        StartQueryExecutionRequest other = (StartQueryExecutionRequest)((Object)obj);
        return Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.queryExecutionContext(), other.queryExecutionContext()) && Objects.equals(this.resultConfiguration(), other.resultConfiguration()) && Objects.equals(this.workGroup(), other.workGroup()) && this.hasExecutionParameters() == other.hasExecutionParameters() && Objects.equals(this.executionParameters(), other.executionParameters()) && Objects.equals(this.resultReuseConfiguration(), other.resultReuseConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"StartQueryExecutionRequest").add("QueryString", (Object)this.queryString()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("QueryExecutionContext", (Object)this.queryExecutionContext()).add("ResultConfiguration", (Object)this.resultConfiguration()).add("WorkGroup", (Object)this.workGroup()).add("ExecutionParameters", this.hasExecutionParameters() ? this.executionParameters() : null).add("ResultReuseConfiguration", (Object)this.resultReuseConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "QueryExecutionContext": {
                return Optional.ofNullable(clazz.cast(this.queryExecutionContext()));
            }
            case "ResultConfiguration": {
                return Optional.ofNullable(clazz.cast(this.resultConfiguration()));
            }
            case "WorkGroup": {
                return Optional.ofNullable(clazz.cast(this.workGroup()));
            }
            case "ExecutionParameters": {
                return Optional.ofNullable(clazz.cast(this.executionParameters()));
            }
            case "ResultReuseConfiguration": {
                return Optional.ofNullable(clazz.cast(this.resultReuseConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartQueryExecutionRequest, T> g) {
        return obj -> g.apply((StartQueryExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String queryString;
        private String clientRequestToken;
        private QueryExecutionContext queryExecutionContext;
        private ResultConfiguration resultConfiguration;
        private String workGroup;
        private List<String> executionParameters = DefaultSdkAutoConstructList.getInstance();
        private ResultReuseConfiguration resultReuseConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartQueryExecutionRequest model) {
            super(model);
            this.queryString(model.queryString);
            this.clientRequestToken(model.clientRequestToken);
            this.queryExecutionContext(model.queryExecutionContext);
            this.resultConfiguration(model.resultConfiguration);
            this.workGroup(model.workGroup);
            this.executionParameters(model.executionParameters);
            this.resultReuseConfiguration(model.resultReuseConfiguration);
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final QueryExecutionContext.Builder getQueryExecutionContext() {
            return this.queryExecutionContext != null ? this.queryExecutionContext.toBuilder() : null;
        }

        public final void setQueryExecutionContext(QueryExecutionContext.BuilderImpl queryExecutionContext) {
            this.queryExecutionContext = queryExecutionContext != null ? queryExecutionContext.build() : null;
        }

        @Override
        public final Builder queryExecutionContext(QueryExecutionContext queryExecutionContext) {
            this.queryExecutionContext = queryExecutionContext;
            return this;
        }

        public final ResultConfiguration.Builder getResultConfiguration() {
            return this.resultConfiguration != null ? this.resultConfiguration.toBuilder() : null;
        }

        public final void setResultConfiguration(ResultConfiguration.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        @Override
        public final Builder resultConfiguration(ResultConfiguration resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        public final String getWorkGroup() {
            return this.workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final Collection<String> getExecutionParameters() {
            if (this.executionParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.executionParameters;
        }

        public final void setExecutionParameters(Collection<String> executionParameters) {
            this.executionParameters = ExecutionParametersCopier.copy(executionParameters);
        }

        @Override
        public final Builder executionParameters(Collection<String> executionParameters) {
            this.executionParameters = ExecutionParametersCopier.copy(executionParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionParameters(String ... executionParameters) {
            this.executionParameters(Arrays.asList(executionParameters));
            return this;
        }

        public final ResultReuseConfiguration.Builder getResultReuseConfiguration() {
            return this.resultReuseConfiguration != null ? this.resultReuseConfiguration.toBuilder() : null;
        }

        public final void setResultReuseConfiguration(ResultReuseConfiguration.BuilderImpl resultReuseConfiguration) {
            this.resultReuseConfiguration = resultReuseConfiguration != null ? resultReuseConfiguration.build() : null;
        }

        @Override
        public final Builder resultReuseConfiguration(ResultReuseConfiguration resultReuseConfiguration) {
            this.resultReuseConfiguration = resultReuseConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartQueryExecutionRequest build() {
            return new StartQueryExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartQueryExecutionRequest> {
        public Builder queryString(String var1);

        public Builder clientRequestToken(String var1);

        public Builder queryExecutionContext(QueryExecutionContext var1);

        default public Builder queryExecutionContext(Consumer<QueryExecutionContext.Builder> queryExecutionContext) {
            return this.queryExecutionContext((QueryExecutionContext)((QueryExecutionContext.Builder)QueryExecutionContext.builder().applyMutation(queryExecutionContext)).build());
        }

        public Builder resultConfiguration(ResultConfiguration var1);

        default public Builder resultConfiguration(Consumer<ResultConfiguration.Builder> resultConfiguration) {
            return this.resultConfiguration((ResultConfiguration)((ResultConfiguration.Builder)ResultConfiguration.builder().applyMutation(resultConfiguration)).build());
        }

        public Builder workGroup(String var1);

        public Builder executionParameters(Collection<String> var1);

        public Builder executionParameters(String ... var1);

        public Builder resultReuseConfiguration(ResultReuseConfiguration var1);

        default public Builder resultReuseConfiguration(Consumer<ResultReuseConfiguration.Builder> resultReuseConfiguration) {
            return this.resultReuseConfiguration((ResultReuseConfiguration)((ResultReuseConfiguration.Builder)ResultReuseConfiguration.builder().applyMutation(resultReuseConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

