/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse;

public class ListPreparedStatementsPublisher
implements SdkPublisher<ListPreparedStatementsResponse> {
    private final AthenaAsyncClient client;
    private final ListPreparedStatementsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPreparedStatementsPublisher(AthenaAsyncClient client, ListPreparedStatementsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPreparedStatementsPublisher(AthenaAsyncClient client, ListPreparedStatementsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPreparedStatementsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPreparedStatementsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPreparedStatementsResponseFetcher
    implements AsyncPageFetcher<ListPreparedStatementsResponse> {
        private ListPreparedStatementsResponseFetcher() {
        }

        public boolean hasNextPage(ListPreparedStatementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPreparedStatementsResponse> nextPage(ListPreparedStatementsResponse previousPage) {
            if (previousPage == null) {
                return ListPreparedStatementsPublisher.this.client.listPreparedStatements(ListPreparedStatementsPublisher.this.firstRequest);
            }
            return ListPreparedStatementsPublisher.this.client.listPreparedStatements((ListPreparedStatementsRequest)((Object)ListPreparedStatementsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

