/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.AthenaClientBuilder;
import software.amazon.awssdk.services.athena.AthenaServiceClientConfiguration;
import software.amazon.awssdk.services.athena.DefaultAthenaBaseClientBuilder;
import software.amazon.awssdk.services.athena.DefaultAthenaClient;
import software.amazon.awssdk.services.athena.endpoints.AthenaEndpointProvider;

@SdkInternalApi
final class DefaultAthenaClientBuilder
extends DefaultAthenaBaseClientBuilder<AthenaClientBuilder, AthenaClient>
implements AthenaClientBuilder {
    DefaultAthenaClientBuilder() {
    }

    @Override
    public DefaultAthenaClientBuilder endpointProvider(AthenaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AthenaClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAthenaClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        AthenaServiceClientConfiguration serviceClientConfiguration = AthenaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultAthenaClient(serviceClientConfiguration, clientConfiguration);
    }
}

