/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.SessionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSessionStatusResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, GetSessionStatusResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(GetSessionStatusResponse.getter(GetSessionStatusResponse::sessionId)).setter(GetSessionStatusResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<SessionStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(GetSessionStatusResponse.getter(GetSessionStatusResponse::status)).setter(GetSessionStatusResponse.setter(Builder::status)).constructor(SessionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, STATUS_FIELD));
    private final String sessionId;
    private final SessionStatus status;

    private GetSessionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.status = builder.status;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final SessionStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionStatusResponse)) {
            return false;
        }
        GetSessionStatusResponse other = (GetSessionStatusResponse)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"GetSessionStatusResponse").add("SessionId", (Object)this.sessionId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSessionStatusResponse, T> g) {
        return obj -> g.apply((GetSessionStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private String sessionId;
        private SessionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionStatusResponse model) {
            super(model);
            this.sessionId(model.sessionId);
            this.status(model.status);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final SessionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(SessionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public GetSessionStatusResponse build() {
            return new GetSessionStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSessionStatusResponse> {
        public Builder sessionId(String var1);

        public Builder status(SessionStatus var1);

        default public Builder status(Consumer<SessionStatus.Builder> status) {
            return this.status((SessionStatus)((SessionStatus.Builder)SessionStatus.builder().applyMutation(status)).build());
        }
    }
}

