/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DataCatalogType {
    LAMBDA("LAMBDA"),
    GLUE("GLUE"),
    HIVE("HIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DataCatalogType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataCatalogType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DataCatalogType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataCatalogType> knownValues() {
        return Stream.of(DataCatalogType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

