/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.DataCatalogSummary;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse;

public class ListDataCatalogsPublisher
implements SdkPublisher<ListDataCatalogsResponse> {
    private final AthenaAsyncClient client;
    private final ListDataCatalogsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataCatalogsPublisher(AthenaAsyncClient client, ListDataCatalogsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataCatalogsPublisher(AthenaAsyncClient client, ListDataCatalogsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataCatalogsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataCatalogsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataCatalogSummary> dataCatalogsSummary() {
        Function<ListDataCatalogsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataCatalogsSummary() != null) {
                return response.dataCatalogsSummary().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataCatalogsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataCatalogsResponseFetcher
    implements AsyncPageFetcher<ListDataCatalogsResponse> {
        private ListDataCatalogsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataCatalogsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataCatalogsResponse> nextPage(ListDataCatalogsResponse previousPage) {
            if (previousPage == null) {
                return ListDataCatalogsPublisher.this.client.listDataCatalogs(ListDataCatalogsPublisher.this.firstRequest);
            }
            return ListDataCatalogsPublisher.this.client.listDataCatalogs((ListDataCatalogsRequest)((Object)ListDataCatalogsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

