/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryExecutionStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryExecutionStatistics> {
    private static final SdkField<Long> ENGINE_EXECUTION_TIME_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EngineExecutionTimeInMillis").getter(QueryExecutionStatistics.getter(QueryExecutionStatistics::engineExecutionTimeInMillis)).setter(QueryExecutionStatistics.setter(Builder::engineExecutionTimeInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineExecutionTimeInMillis").build()}).build();
    private static final SdkField<Long> DATA_SCANNED_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DataScannedInBytes").getter(QueryExecutionStatistics.getter(QueryExecutionStatistics::dataScannedInBytes)).setter(QueryExecutionStatistics.setter(Builder::dataScannedInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataScannedInBytes").build()}).build();
    private static final SdkField<String> DATA_MANIFEST_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataManifestLocation").getter(QueryExecutionStatistics.getter(QueryExecutionStatistics::dataManifestLocation)).setter(QueryExecutionStatistics.setter(Builder::dataManifestLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataManifestLocation").build()}).build();
    private static final SdkField<Long> TOTAL_EXECUTION_TIME_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalExecutionTimeInMillis").getter(QueryExecutionStatistics.getter(QueryExecutionStatistics::totalExecutionTimeInMillis)).setter(QueryExecutionStatistics.setter(Builder::totalExecutionTimeInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalExecutionTimeInMillis").build()}).build();
    private static final SdkField<Long> QUERY_QUEUE_TIME_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("QueryQueueTimeInMillis").getter(QueryExecutionStatistics.getter(QueryExecutionStatistics::queryQueueTimeInMillis)).setter(QueryExecutionStatistics.setter(Builder::queryQueueTimeInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryQueueTimeInMillis").build()}).build();
    private static final SdkField<Long> QUERY_PLANNING_TIME_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("QueryPlanningTimeInMillis").getter(QueryExecutionStatistics.getter(QueryExecutionStatistics::queryPlanningTimeInMillis)).setter(QueryExecutionStatistics.setter(Builder::queryPlanningTimeInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryPlanningTimeInMillis").build()}).build();
    private static final SdkField<Long> SERVICE_PROCESSING_TIME_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ServiceProcessingTimeInMillis").getter(QueryExecutionStatistics.getter(QueryExecutionStatistics::serviceProcessingTimeInMillis)).setter(QueryExecutionStatistics.setter(Builder::serviceProcessingTimeInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceProcessingTimeInMillis").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_EXECUTION_TIME_IN_MILLIS_FIELD, DATA_SCANNED_IN_BYTES_FIELD, DATA_MANIFEST_LOCATION_FIELD, TOTAL_EXECUTION_TIME_IN_MILLIS_FIELD, QUERY_QUEUE_TIME_IN_MILLIS_FIELD, QUERY_PLANNING_TIME_IN_MILLIS_FIELD, SERVICE_PROCESSING_TIME_IN_MILLIS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long engineExecutionTimeInMillis;
    private final Long dataScannedInBytes;
    private final String dataManifestLocation;
    private final Long totalExecutionTimeInMillis;
    private final Long queryQueueTimeInMillis;
    private final Long queryPlanningTimeInMillis;
    private final Long serviceProcessingTimeInMillis;

    private QueryExecutionStatistics(BuilderImpl builder) {
        this.engineExecutionTimeInMillis = builder.engineExecutionTimeInMillis;
        this.dataScannedInBytes = builder.dataScannedInBytes;
        this.dataManifestLocation = builder.dataManifestLocation;
        this.totalExecutionTimeInMillis = builder.totalExecutionTimeInMillis;
        this.queryQueueTimeInMillis = builder.queryQueueTimeInMillis;
        this.queryPlanningTimeInMillis = builder.queryPlanningTimeInMillis;
        this.serviceProcessingTimeInMillis = builder.serviceProcessingTimeInMillis;
    }

    public final Long engineExecutionTimeInMillis() {
        return this.engineExecutionTimeInMillis;
    }

    public final Long dataScannedInBytes() {
        return this.dataScannedInBytes;
    }

    public final String dataManifestLocation() {
        return this.dataManifestLocation;
    }

    public final Long totalExecutionTimeInMillis() {
        return this.totalExecutionTimeInMillis;
    }

    public final Long queryQueueTimeInMillis() {
        return this.queryQueueTimeInMillis;
    }

    public final Long queryPlanningTimeInMillis() {
        return this.queryPlanningTimeInMillis;
    }

    public final Long serviceProcessingTimeInMillis() {
        return this.serviceProcessingTimeInMillis;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engineExecutionTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataScannedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataManifestLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalExecutionTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryQueueTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryPlanningTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceProcessingTimeInMillis());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionStatistics)) {
            return false;
        }
        QueryExecutionStatistics other = (QueryExecutionStatistics)obj;
        return Objects.equals(this.engineExecutionTimeInMillis(), other.engineExecutionTimeInMillis()) && Objects.equals(this.dataScannedInBytes(), other.dataScannedInBytes()) && Objects.equals(this.dataManifestLocation(), other.dataManifestLocation()) && Objects.equals(this.totalExecutionTimeInMillis(), other.totalExecutionTimeInMillis()) && Objects.equals(this.queryQueueTimeInMillis(), other.queryQueueTimeInMillis()) && Objects.equals(this.queryPlanningTimeInMillis(), other.queryPlanningTimeInMillis()) && Objects.equals(this.serviceProcessingTimeInMillis(), other.serviceProcessingTimeInMillis());
    }

    public final String toString() {
        return ToString.builder((String)"QueryExecutionStatistics").add("EngineExecutionTimeInMillis", (Object)this.engineExecutionTimeInMillis()).add("DataScannedInBytes", (Object)this.dataScannedInBytes()).add("DataManifestLocation", (Object)this.dataManifestLocation()).add("TotalExecutionTimeInMillis", (Object)this.totalExecutionTimeInMillis()).add("QueryQueueTimeInMillis", (Object)this.queryQueueTimeInMillis()).add("QueryPlanningTimeInMillis", (Object)this.queryPlanningTimeInMillis()).add("ServiceProcessingTimeInMillis", (Object)this.serviceProcessingTimeInMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngineExecutionTimeInMillis": {
                return Optional.ofNullable(clazz.cast(this.engineExecutionTimeInMillis()));
            }
            case "DataScannedInBytes": {
                return Optional.ofNullable(clazz.cast(this.dataScannedInBytes()));
            }
            case "DataManifestLocation": {
                return Optional.ofNullable(clazz.cast(this.dataManifestLocation()));
            }
            case "TotalExecutionTimeInMillis": {
                return Optional.ofNullable(clazz.cast(this.totalExecutionTimeInMillis()));
            }
            case "QueryQueueTimeInMillis": {
                return Optional.ofNullable(clazz.cast(this.queryQueueTimeInMillis()));
            }
            case "QueryPlanningTimeInMillis": {
                return Optional.ofNullable(clazz.cast(this.queryPlanningTimeInMillis()));
            }
            case "ServiceProcessingTimeInMillis": {
                return Optional.ofNullable(clazz.cast(this.serviceProcessingTimeInMillis()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryExecutionStatistics, T> g) {
        return obj -> g.apply((QueryExecutionStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long engineExecutionTimeInMillis;
        private Long dataScannedInBytes;
        private String dataManifestLocation;
        private Long totalExecutionTimeInMillis;
        private Long queryQueueTimeInMillis;
        private Long queryPlanningTimeInMillis;
        private Long serviceProcessingTimeInMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecutionStatistics model) {
            this.engineExecutionTimeInMillis(model.engineExecutionTimeInMillis);
            this.dataScannedInBytes(model.dataScannedInBytes);
            this.dataManifestLocation(model.dataManifestLocation);
            this.totalExecutionTimeInMillis(model.totalExecutionTimeInMillis);
            this.queryQueueTimeInMillis(model.queryQueueTimeInMillis);
            this.queryPlanningTimeInMillis(model.queryPlanningTimeInMillis);
            this.serviceProcessingTimeInMillis(model.serviceProcessingTimeInMillis);
        }

        public final Long getEngineExecutionTimeInMillis() {
            return this.engineExecutionTimeInMillis;
        }

        public final void setEngineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
            this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
        }

        @Override
        public final Builder engineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
            this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
            return this;
        }

        public final Long getDataScannedInBytes() {
            return this.dataScannedInBytes;
        }

        public final void setDataScannedInBytes(Long dataScannedInBytes) {
            this.dataScannedInBytes = dataScannedInBytes;
        }

        @Override
        public final Builder dataScannedInBytes(Long dataScannedInBytes) {
            this.dataScannedInBytes = dataScannedInBytes;
            return this;
        }

        public final String getDataManifestLocation() {
            return this.dataManifestLocation;
        }

        public final void setDataManifestLocation(String dataManifestLocation) {
            this.dataManifestLocation = dataManifestLocation;
        }

        @Override
        public final Builder dataManifestLocation(String dataManifestLocation) {
            this.dataManifestLocation = dataManifestLocation;
            return this;
        }

        public final Long getTotalExecutionTimeInMillis() {
            return this.totalExecutionTimeInMillis;
        }

        public final void setTotalExecutionTimeInMillis(Long totalExecutionTimeInMillis) {
            this.totalExecutionTimeInMillis = totalExecutionTimeInMillis;
        }

        @Override
        public final Builder totalExecutionTimeInMillis(Long totalExecutionTimeInMillis) {
            this.totalExecutionTimeInMillis = totalExecutionTimeInMillis;
            return this;
        }

        public final Long getQueryQueueTimeInMillis() {
            return this.queryQueueTimeInMillis;
        }

        public final void setQueryQueueTimeInMillis(Long queryQueueTimeInMillis) {
            this.queryQueueTimeInMillis = queryQueueTimeInMillis;
        }

        @Override
        public final Builder queryQueueTimeInMillis(Long queryQueueTimeInMillis) {
            this.queryQueueTimeInMillis = queryQueueTimeInMillis;
            return this;
        }

        public final Long getQueryPlanningTimeInMillis() {
            return this.queryPlanningTimeInMillis;
        }

        public final void setQueryPlanningTimeInMillis(Long queryPlanningTimeInMillis) {
            this.queryPlanningTimeInMillis = queryPlanningTimeInMillis;
        }

        @Override
        public final Builder queryPlanningTimeInMillis(Long queryPlanningTimeInMillis) {
            this.queryPlanningTimeInMillis = queryPlanningTimeInMillis;
            return this;
        }

        public final Long getServiceProcessingTimeInMillis() {
            return this.serviceProcessingTimeInMillis;
        }

        public final void setServiceProcessingTimeInMillis(Long serviceProcessingTimeInMillis) {
            this.serviceProcessingTimeInMillis = serviceProcessingTimeInMillis;
        }

        @Override
        public final Builder serviceProcessingTimeInMillis(Long serviceProcessingTimeInMillis) {
            this.serviceProcessingTimeInMillis = serviceProcessingTimeInMillis;
            return this;
        }

        public QueryExecutionStatistics build() {
            return new QueryExecutionStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryExecutionStatistics> {
        public Builder engineExecutionTimeInMillis(Long var1);

        public Builder dataScannedInBytes(Long var1);

        public Builder dataManifestLocation(String var1);

        public Builder totalExecutionTimeInMillis(Long var1);

        public Builder queryQueueTimeInMillis(Long var1);

        public Builder queryPlanningTimeInMillis(Long var1);

        public Builder serviceProcessingTimeInMillis(Long var1);
    }
}

