/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The rows that comprise a query result table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Row implements SdkPojo, Serializable, ToCopyableBuilder<Row.Builder, Row> {
    private static final SdkField<List<Datum>> DATA_FIELD = SdkField
            .<List<Datum>> builder(MarshallingType.LIST)
            .memberName("Data")
            .getter(getter(Row::data))
            .setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Datum> builder(MarshallingType.SDK_POJO)
                                            .constructor(Datum::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Datum> data;

    private Row(BuilderImpl builder) {
        this.data = builder.data;
    }

    /**
     * Returns true if the Data property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasData() {
        return data != null && !(data instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data that populates a row in a query result table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasData()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The data that populates a row in a query result table.
     */
    public final List<Datum> data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasData() ? data() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Row)) {
            return false;
        }
        Row other = (Row) obj;
        return hasData() == other.hasData() && Objects.equals(data(), other.data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Row").add("Data", hasData() ? data() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Row, T> g) {
        return obj -> g.apply((Row) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Row> {
        /**
         * <p>
         * The data that populates a row in a query result table.
         * </p>
         * 
         * @param data
         *        The data that populates a row in a query result table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(Collection<Datum> data);

        /**
         * <p>
         * The data that populates a row in a query result table.
         * </p>
         * 
         * @param data
         *        The data that populates a row in a query result table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(Datum... data);

        /**
         * <p>
         * The data that populates a row in a query result table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Datum>.Builder} avoiding the need to create
         * one manually via {@link List<Datum>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Datum>.Builder#build()} is called immediately and its result
         * is passed to {@link #data(List<Datum>)}.
         * 
         * @param data
         *        a consumer that will call methods on {@link List<Datum>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(List<Datum>)
         */
        Builder data(Consumer<Datum.Builder>... data);
    }

    static final class BuilderImpl implements Builder {
        private List<Datum> data = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Row model) {
            data(model.data);
        }

        public final Collection<Datum.Builder> getData() {
            if (data instanceof SdkAutoConstructList) {
                return null;
            }
            return data != null ? data.stream().map(Datum::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder data(Collection<Datum> data) {
            this.data = _datumListCopier.copy(data);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(Datum... data) {
            data(Arrays.asList(data));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(Consumer<Datum.Builder>... data) {
            data(Stream.of(data).map(c -> Datum.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setData(Collection<Datum.BuilderImpl> data) {
            this.data = _datumListCopier.copyFromBuilder(data);
        }

        @Override
        public Row build() {
            return new Row(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
