/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteWorkGroupRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, DeleteWorkGroupRequest> {
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkGroup").getter(DeleteWorkGroupRequest.getter(DeleteWorkGroupRequest::workGroup)).setter(DeleteWorkGroupRequest.setter(Builder::workGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()}).build();
    private static final SdkField<Boolean> RECURSIVE_DELETE_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RecursiveDeleteOption").getter(DeleteWorkGroupRequest.getter(DeleteWorkGroupRequest::recursiveDeleteOption)).setter(DeleteWorkGroupRequest.setter(Builder::recursiveDeleteOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecursiveDeleteOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORK_GROUP_FIELD, RECURSIVE_DELETE_OPTION_FIELD));
    private final String workGroup;
    private final Boolean recursiveDeleteOption;

    private DeleteWorkGroupRequest(BuilderImpl builder) {
        super(builder);
        this.workGroup = builder.workGroup;
        this.recursiveDeleteOption = builder.recursiveDeleteOption;
    }

    public String workGroup() {
        return this.workGroup;
    }

    public Boolean recursiveDeleteOption() {
        return this.recursiveDeleteOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.recursiveDeleteOption());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteWorkGroupRequest)) {
            return false;
        }
        DeleteWorkGroupRequest other = (DeleteWorkGroupRequest)((Object)obj);
        return Objects.equals(this.workGroup(), other.workGroup()) && Objects.equals(this.recursiveDeleteOption(), other.recursiveDeleteOption());
    }

    public String toString() {
        return ToString.builder((String)"DeleteWorkGroupRequest").add("WorkGroup", (Object)this.workGroup()).add("RecursiveDeleteOption", (Object)this.recursiveDeleteOption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkGroup": {
                return Optional.ofNullable(clazz.cast(this.workGroup()));
            }
            case "RecursiveDeleteOption": {
                return Optional.ofNullable(clazz.cast(this.recursiveDeleteOption()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteWorkGroupRequest, T> g) {
        return obj -> g.apply((DeleteWorkGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String workGroup;
        private Boolean recursiveDeleteOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteWorkGroupRequest model) {
            super(model);
            this.workGroup(model.workGroup);
            this.recursiveDeleteOption(model.recursiveDeleteOption);
        }

        public final String getWorkGroup() {
            return this.workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        public final Boolean getRecursiveDeleteOption() {
            return this.recursiveDeleteOption;
        }

        @Override
        public final Builder recursiveDeleteOption(Boolean recursiveDeleteOption) {
            this.recursiveDeleteOption = recursiveDeleteOption;
            return this;
        }

        public final void setRecursiveDeleteOption(Boolean recursiveDeleteOption) {
            this.recursiveDeleteOption = recursiveDeleteOption;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteWorkGroupRequest build() {
            return new DeleteWorkGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteWorkGroupRequest> {
        public Builder workGroup(String var1);

        public Builder recursiveDeleteOption(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

