/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.model.AthenaException;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.CreateDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.CreateDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.CreateWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.CreateWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.DeleteDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.DeleteDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.DeleteWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.DeleteWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.GetDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.GetDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.GetDatabaseRequest;
import software.amazon.awssdk.services.athena.model.GetDatabaseResponse;
import software.amazon.awssdk.services.athena.model.GetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.GetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.GetTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.GetTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.GetWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.GetWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.InternalServerException;
import software.amazon.awssdk.services.athena.model.InvalidRequestException;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse;
import software.amazon.awssdk.services.athena.model.ListDatabasesRequest;
import software.amazon.awssdk.services.athena.model.ListDatabasesResponse;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse;
import software.amazon.awssdk.services.athena.model.ListTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse;
import software.amazon.awssdk.services.athena.model.MetadataException;
import software.amazon.awssdk.services.athena.model.ResourceNotFoundException;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.TagResourceRequest;
import software.amazon.awssdk.services.athena.model.TagResourceResponse;
import software.amazon.awssdk.services.athena.model.TooManyRequestsException;
import software.amazon.awssdk.services.athena.model.UntagResourceRequest;
import software.amazon.awssdk.services.athena.model.UntagResourceResponse;
import software.amazon.awssdk.services.athena.model.UpdateDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.UpdateDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.UpdateWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.UpdateWorkGroupResponse;
import software.amazon.awssdk.services.athena.paginators.GetQueryResultsIterable;
import software.amazon.awssdk.services.athena.paginators.ListDataCatalogsIterable;
import software.amazon.awssdk.services.athena.paginators.ListDatabasesIterable;
import software.amazon.awssdk.services.athena.paginators.ListNamedQueriesIterable;
import software.amazon.awssdk.services.athena.paginators.ListQueryExecutionsIterable;
import software.amazon.awssdk.services.athena.paginators.ListTableMetadataIterable;
import software.amazon.awssdk.services.athena.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.athena.paginators.ListWorkGroupsIterable;
import software.amazon.awssdk.services.athena.transform.BatchGetNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.BatchGetQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetDatabaseRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryResultsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetTableMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListDataCatalogsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListDatabasesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNamedQueriesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListQueryExecutionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListTableMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListWorkGroupsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StopQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateWorkGroupRequestMarshaller;

@SdkInternalApi
final class DefaultAthenaClient
implements AthenaClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAthenaClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "athena";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetNamedQueryResponse batchGetNamedQuery(BatchGetNamedQueryRequest batchGetNamedQueryRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetNamedQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetNamedQuery");
            BatchGetNamedQueryResponse batchGetNamedQueryResponse = (BatchGetNamedQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetNamedQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetNamedQueryRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetNamedQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetNamedQueryResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, batchGetNamedQueryRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetQueryExecutionResponse batchGetQueryExecution(BatchGetQueryExecutionRequest batchGetQueryExecutionRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetQueryExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetQueryExecution");
            BatchGetQueryExecutionResponse batchGetQueryExecutionResponse = (BatchGetQueryExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetQueryExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetQueryExecutionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetQueryExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetQueryExecutionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, batchGetQueryExecutionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataCatalogResponse createDataCatalog(CreateDataCatalogRequest createDataCatalogRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataCatalogResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataCatalog");
            CreateDataCatalogResponse createDataCatalogResponse = (CreateDataCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataCatalog").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataCatalogRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataCatalogResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, createDataCatalogRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateNamedQueryResponse createNamedQuery(CreateNamedQueryRequest createNamedQueryRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNamedQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateNamedQuery");
            CreateNamedQueryResponse createNamedQueryResponse = (CreateNamedQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNamedQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createNamedQueryRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateNamedQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createNamedQueryResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, createNamedQueryRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkGroupResponse createWorkGroup(CreateWorkGroupRequest createWorkGroupRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkGroup");
            CreateWorkGroupResponse createWorkGroupResponse = (CreateWorkGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorkGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorkGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorkGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, createWorkGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataCatalogResponse deleteDataCatalog(DeleteDataCatalogRequest deleteDataCatalogRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataCatalogResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataCatalog");
            DeleteDataCatalogResponse deleteDataCatalogResponse = (DeleteDataCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataCatalog").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDataCatalogRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataCatalogResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, deleteDataCatalogRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNamedQueryResponse deleteNamedQuery(DeleteNamedQueryRequest deleteNamedQueryRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNamedQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNamedQuery");
            DeleteNamedQueryResponse deleteNamedQueryResponse = (DeleteNamedQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNamedQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteNamedQueryRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteNamedQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteNamedQueryResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, deleteNamedQueryRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorkGroupResponse deleteWorkGroup(DeleteWorkGroupRequest deleteWorkGroupRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkGroup");
            DeleteWorkGroupResponse deleteWorkGroupResponse = (DeleteWorkGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWorkGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWorkGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWorkGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, deleteWorkGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataCatalogResponse getDataCatalog(GetDataCatalogRequest getDataCatalogRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataCatalogResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataCatalog");
            GetDataCatalogResponse getDataCatalogResponse = (GetDataCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataCatalog").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDataCatalogRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetDataCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDataCatalogResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getDataCatalogRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDatabaseResponse getDatabase(GetDatabaseRequest getDatabaseRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDatabaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDatabase");
            GetDatabaseResponse getDatabaseResponse = (GetDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDatabase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDatabaseRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDatabaseResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getDatabaseRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetNamedQueryResponse getNamedQuery(GetNamedQueryRequest getNamedQueryRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNamedQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetNamedQuery");
            GetNamedQueryResponse getNamedQueryResponse = (GetNamedQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNamedQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getNamedQueryRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetNamedQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getNamedQueryResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getNamedQueryRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryExecutionResponse getQueryExecution(GetQueryExecutionRequest getQueryExecutionRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryExecution");
            GetQueryExecutionResponse getQueryExecutionResponse = (GetQueryExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQueryExecutionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetQueryExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getQueryExecutionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getQueryExecutionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryResultsResponse getQueryResults(GetQueryResultsRequest getQueryResultsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryResultsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryResults");
            GetQueryResultsResponse getQueryResultsResponse = (GetQueryResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryResults").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQueryResultsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetQueryResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getQueryResultsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getQueryResultsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public GetQueryResultsIterable getQueryResultsPaginator(GetQueryResultsRequest getQueryResultsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        return new GetQueryResultsIterable(this, this.applyPaginatorUserAgent(getQueryResultsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTableMetadataResponse getTableMetadata(GetTableMetadataRequest getTableMetadataRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTableMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTableMetadata");
            GetTableMetadataResponse getTableMetadataResponse = (GetTableMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTableMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTableMetadataRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetTableMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTableMetadataResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getTableMetadataRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWorkGroupResponse getWorkGroup(GetWorkGroupRequest getWorkGroupRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkGroup");
            GetWorkGroupResponse getWorkGroupResponse = (GetWorkGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getWorkGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetWorkGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getWorkGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, getWorkGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDataCatalogsResponse listDataCatalogs(ListDataCatalogsRequest listDataCatalogsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataCatalogsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDataCatalogs");
            ListDataCatalogsResponse listDataCatalogsResponse = (ListDataCatalogsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataCatalogs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDataCatalogsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListDataCatalogsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDataCatalogsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listDataCatalogsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListDataCatalogsIterable listDataCatalogsPaginator(ListDataCatalogsRequest listDataCatalogsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        return new ListDataCatalogsIterable(this, this.applyPaginatorUserAgent(listDataCatalogsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatabasesResponse listDatabases(ListDatabasesRequest listDatabasesRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatabasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatabases");
            ListDatabasesResponse listDatabasesResponse = (ListDatabasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatabases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatabasesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListDatabasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatabasesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listDatabasesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListDatabasesIterable listDatabasesPaginator(ListDatabasesRequest listDatabasesRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        return new ListDatabasesIterable(this, this.applyPaginatorUserAgent(listDatabasesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNamedQueriesResponse listNamedQueries(ListNamedQueriesRequest listNamedQueriesRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNamedQueriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNamedQueries");
            ListNamedQueriesResponse listNamedQueriesResponse = (ListNamedQueriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNamedQueries").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNamedQueriesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListNamedQueriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNamedQueriesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listNamedQueriesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListNamedQueriesIterable listNamedQueriesPaginator(ListNamedQueriesRequest listNamedQueriesRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        return new ListNamedQueriesIterable(this, this.applyPaginatorUserAgent(listNamedQueriesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListQueryExecutionsResponse listQueryExecutions(ListQueryExecutionsRequest listQueryExecutionsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListQueryExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListQueryExecutions");
            ListQueryExecutionsResponse listQueryExecutionsResponse = (ListQueryExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQueryExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listQueryExecutionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListQueryExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listQueryExecutionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listQueryExecutionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListQueryExecutionsIterable listQueryExecutionsPaginator(ListQueryExecutionsRequest listQueryExecutionsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        return new ListQueryExecutionsIterable(this, this.applyPaginatorUserAgent(listQueryExecutionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTableMetadataResponse listTableMetadata(ListTableMetadataRequest listTableMetadataRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTableMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTableMetadata");
            ListTableMetadataResponse listTableMetadataResponse = (ListTableMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTableMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTableMetadataRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTableMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTableMetadataResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listTableMetadataRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListTableMetadataIterable listTableMetadataPaginator(ListTableMetadataRequest listTableMetadataRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        return new ListTableMetadataIterable(this, this.applyPaginatorUserAgent(listTableMetadataRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorkGroupsResponse listWorkGroups(ListWorkGroupsRequest listWorkGroupsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkGroups");
            ListWorkGroupsResponse listWorkGroupsResponse = (ListWorkGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorkGroupsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListWorkGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorkGroupsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, listWorkGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListWorkGroupsIterable listWorkGroupsPaginator(ListWorkGroupsRequest listWorkGroupsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        return new ListWorkGroupsIterable(this, this.applyPaginatorUserAgent(listWorkGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartQueryExecutionResponse startQueryExecution(StartQueryExecutionRequest startQueryExecutionRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartQueryExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartQueryExecution");
            StartQueryExecutionResponse startQueryExecutionResponse = (StartQueryExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartQueryExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startQueryExecutionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StartQueryExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startQueryExecutionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, startQueryExecutionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopQueryExecutionResponse stopQueryExecution(StopQueryExecutionRequest stopQueryExecutionRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopQueryExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopQueryExecution");
            StopQueryExecutionResponse stopQueryExecutionResponse = (StopQueryExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopQueryExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopQueryExecutionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StopQueryExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopQueryExecutionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, stopQueryExecutionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDataCatalogResponse updateDataCatalog(UpdateDataCatalogRequest updateDataCatalogRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataCatalogResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataCatalog");
            UpdateDataCatalogResponse updateDataCatalogResponse = (UpdateDataCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataCatalog").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDataCatalogRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDataCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDataCatalogResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, updateDataCatalogRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWorkGroupResponse updateWorkGroup(UpdateWorkGroupRequest updateWorkGroupRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWorkGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWorkGroup");
            UpdateWorkGroupResponse updateWorkGroupResponse = (UpdateWorkGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWorkGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateWorkGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWorkGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWorkGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(this.clientConfiguration, updateWorkGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AthenaException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("MetadataException").exceptionBuilderSupplier(MetadataException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends AthenaRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.56").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AthenaRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

