/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetNamedQueryResponse extends AthenaResponse implements
        ToCopyableBuilder<BatchGetNamedQueryResponse.Builder, BatchGetNamedQueryResponse> {
    private static final SdkField<List<NamedQuery>> NAMED_QUERIES_FIELD = SdkField
            .<List<NamedQuery>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetNamedQueryResponse::namedQueries))
            .setter(setter(Builder::namedQueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedQueries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NamedQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(NamedQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedNamedQueryId>> UNPROCESSED_NAMED_QUERY_IDS_FIELD = SdkField
            .<List<UnprocessedNamedQueryId>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetNamedQueryResponse::unprocessedNamedQueryIds))
            .setter(setter(Builder::unprocessedNamedQueryIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedNamedQueryIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedNamedQueryId> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedNamedQueryId::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMED_QUERIES_FIELD,
            UNPROCESSED_NAMED_QUERY_IDS_FIELD));

    private final List<NamedQuery> namedQueries;

    private final List<UnprocessedNamedQueryId> unprocessedNamedQueryIds;

    private BatchGetNamedQueryResponse(BuilderImpl builder) {
        super(builder);
        this.namedQueries = builder.namedQueries;
        this.unprocessedNamedQueryIds = builder.unprocessedNamedQueryIds;
    }

    /**
     * Returns true if the NamedQueries property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasNamedQueries() {
        return namedQueries != null && !(namedQueries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the named query IDs submitted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNamedQueries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the named query IDs submitted.
     */
    public List<NamedQuery> namedQueries() {
        return namedQueries;
    }

    /**
     * Returns true if the UnprocessedNamedQueryIds property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasUnprocessedNamedQueryIds() {
        return unprocessedNamedQueryIds != null && !(unprocessedNamedQueryIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about provided query IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedNamedQueryIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about provided query IDs.
     */
    public List<UnprocessedNamedQueryId> unprocessedNamedQueryIds() {
        return unprocessedNamedQueryIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namedQueries());
        hashCode = 31 * hashCode + Objects.hashCode(unprocessedNamedQueryIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetNamedQueryResponse)) {
            return false;
        }
        BatchGetNamedQueryResponse other = (BatchGetNamedQueryResponse) obj;
        return Objects.equals(namedQueries(), other.namedQueries())
                && Objects.equals(unprocessedNamedQueryIds(), other.unprocessedNamedQueryIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetNamedQueryResponse").add("NamedQueries", namedQueries())
                .add("UnprocessedNamedQueryIds", unprocessedNamedQueryIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamedQueries":
            return Optional.ofNullable(clazz.cast(namedQueries()));
        case "UnprocessedNamedQueryIds":
            return Optional.ofNullable(clazz.cast(unprocessedNamedQueryIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetNamedQueryResponse, T> g) {
        return obj -> g.apply((BatchGetNamedQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetNamedQueryResponse> {
        /**
         * <p>
         * Information about the named query IDs submitted.
         * </p>
         * 
         * @param namedQueries
         *        Information about the named query IDs submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedQueries(Collection<NamedQuery> namedQueries);

        /**
         * <p>
         * Information about the named query IDs submitted.
         * </p>
         * 
         * @param namedQueries
         *        Information about the named query IDs submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedQueries(NamedQuery... namedQueries);

        /**
         * <p>
         * Information about the named query IDs submitted.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NamedQuery>.Builder} avoiding the need to
         * create one manually via {@link List<NamedQuery>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NamedQuery>.Builder#build()} is called immediately and its
         * result is passed to {@link #namedQueries(List<NamedQuery>)}.
         * 
         * @param namedQueries
         *        a consumer that will call methods on {@link List<NamedQuery>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #namedQueries(List<NamedQuery>)
         */
        Builder namedQueries(Consumer<NamedQuery.Builder>... namedQueries);

        /**
         * <p>
         * Information about provided query IDs.
         * </p>
         * 
         * @param unprocessedNamedQueryIds
         *        Information about provided query IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedNamedQueryIds(Collection<UnprocessedNamedQueryId> unprocessedNamedQueryIds);

        /**
         * <p>
         * Information about provided query IDs.
         * </p>
         * 
         * @param unprocessedNamedQueryIds
         *        Information about provided query IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedNamedQueryIds(UnprocessedNamedQueryId... unprocessedNamedQueryIds);

        /**
         * <p>
         * Information about provided query IDs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UnprocessedNamedQueryId>.Builder} avoiding
         * the need to create one manually via {@link List<UnprocessedNamedQueryId>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnprocessedNamedQueryId>.Builder#build()} is called
         * immediately and its result is passed to {@link #unprocessedNamedQueryIds(List<UnprocessedNamedQueryId>)}.
         * 
         * @param unprocessedNamedQueryIds
         *        a consumer that will call methods on {@link List<UnprocessedNamedQueryId>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedNamedQueryIds(List<UnprocessedNamedQueryId>)
         */
        Builder unprocessedNamedQueryIds(Consumer<UnprocessedNamedQueryId.Builder>... unprocessedNamedQueryIds);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private List<NamedQuery> namedQueries = DefaultSdkAutoConstructList.getInstance();

        private List<UnprocessedNamedQueryId> unprocessedNamedQueryIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetNamedQueryResponse model) {
            super(model);
            namedQueries(model.namedQueries);
            unprocessedNamedQueryIds(model.unprocessedNamedQueryIds);
        }

        public final Collection<NamedQuery.Builder> getNamedQueries() {
            return namedQueries != null ? namedQueries.stream().map(NamedQuery::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder namedQueries(Collection<NamedQuery> namedQueries) {
            this.namedQueries = NamedQueryListCopier.copy(namedQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedQueries(NamedQuery... namedQueries) {
            namedQueries(Arrays.asList(namedQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedQueries(Consumer<NamedQuery.Builder>... namedQueries) {
            namedQueries(Stream.of(namedQueries).map(c -> NamedQuery.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNamedQueries(Collection<NamedQuery.BuilderImpl> namedQueries) {
            this.namedQueries = NamedQueryListCopier.copyFromBuilder(namedQueries);
        }

        public final Collection<UnprocessedNamedQueryId.Builder> getUnprocessedNamedQueryIds() {
            return unprocessedNamedQueryIds != null ? unprocessedNamedQueryIds.stream().map(UnprocessedNamedQueryId::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedNamedQueryIds(Collection<UnprocessedNamedQueryId> unprocessedNamedQueryIds) {
            this.unprocessedNamedQueryIds = UnprocessedNamedQueryIdListCopier.copy(unprocessedNamedQueryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedNamedQueryIds(UnprocessedNamedQueryId... unprocessedNamedQueryIds) {
            unprocessedNamedQueryIds(Arrays.asList(unprocessedNamedQueryIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedNamedQueryIds(Consumer<UnprocessedNamedQueryId.Builder>... unprocessedNamedQueryIds) {
            unprocessedNamedQueryIds(Stream.of(unprocessedNamedQueryIds)
                    .map(c -> UnprocessedNamedQueryId.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedNamedQueryIds(Collection<UnprocessedNamedQueryId.BuilderImpl> unprocessedNamedQueryIds) {
            this.unprocessedNamedQueryIds = UnprocessedNamedQueryIdListCopier.copyFromBuilder(unprocessedNamedQueryIds);
        }

        @Override
        public BatchGetNamedQueryResponse build() {
            return new BatchGetNamedQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
