/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.athena.model.QueryExecutionStatus;

@SdkInternalApi
public class QueryExecutionStatusMarshaller {
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> STATECHANGEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateChangeReason").build();
    private static final MarshallingInfo<Instant> SUBMISSIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmissionDateTime").build();
    private static final MarshallingInfo<Instant> COMPLETIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletionDateTime").build();
    private static final QueryExecutionStatusMarshaller INSTANCE = new QueryExecutionStatusMarshaller();

    public static QueryExecutionStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(QueryExecutionStatus queryExecutionStatus, ProtocolMarshaller protocolMarshaller) {
        if (queryExecutionStatus == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)queryExecutionStatus.stateString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)queryExecutionStatus.stateChangeReason(), STATECHANGEREASON_BINDING);
            protocolMarshaller.marshall((Object)queryExecutionStatus.submissionDateTime(), SUBMISSIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)queryExecutionStatus.completionDateTime(), COMPLETIONDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

