/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.transform.QueryExecutionContextMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class QueryExecutionContext
implements StructuredPojo,
ToCopyableBuilder<Builder, QueryExecutionContext> {
    private final String database;

    private QueryExecutionContext(BuilderImpl builder) {
        this.database = builder.database;
    }

    public String database() {
        return this.database;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionContext)) {
            return false;
        }
        QueryExecutionContext other = (QueryExecutionContext)obj;
        return Objects.equals(this.database(), other.database());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.database() != null) {
            sb.append("Database: ").append(this.database()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Database": {
                return Optional.of(clazz.cast(this.database()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueryExecutionContextMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String database;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecutionContext model) {
            this.database(model.database);
        }

        public final String getDatabase() {
            return this.database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public QueryExecutionContext build() {
            return new QueryExecutionContext(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, QueryExecutionContext> {
        public Builder database(String var1);
    }
}

