/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.athena.model.NamedQueryIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListNamedQueriesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListNamedQueriesResponse> {
    private final List<String> namedQueryIds;
    private final String nextToken;

    private ListNamedQueriesResponse(BuilderImpl builder) {
        this.namedQueryIds = builder.namedQueryIds;
        this.nextToken = builder.nextToken;
    }

    public List<String> namedQueryIds() {
        return this.namedQueryIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.namedQueryIds() == null ? 0 : this.namedQueryIds().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNamedQueriesResponse)) {
            return false;
        }
        ListNamedQueriesResponse other = (ListNamedQueriesResponse)((Object)obj);
        if (other.namedQueryIds() == null ^ this.namedQueryIds() == null) {
            return false;
        }
        if (other.namedQueryIds() != null && !other.namedQueryIds().equals(this.namedQueryIds())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.namedQueryIds() != null) {
            sb.append("NamedQueryIds: ").append(this.namedQueryIds()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamedQueryIds": {
                return Optional.of(clazz.cast(this.namedQueryIds()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> namedQueryIds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNamedQueriesResponse model) {
            this.namedQueryIds(model.namedQueryIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getNamedQueryIds() {
            return this.namedQueryIds;
        }

        @Override
        public final Builder namedQueryIds(Collection<String> namedQueryIds) {
            this.namedQueryIds = NamedQueryIdListCopier.copy(namedQueryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedQueryIds(String ... namedQueryIds) {
            this.namedQueryIds(Arrays.asList(namedQueryIds));
            return this;
        }

        public final void setNamedQueryIds(Collection<String> namedQueryIds) {
            this.namedQueryIds = NamedQueryIdListCopier.copy(namedQueryIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListNamedQueriesResponse build() {
            return new ListNamedQueriesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListNamedQueriesResponse> {
        public Builder namedQueryIds(Collection<String> var1);

        public Builder namedQueryIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

