/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.EncryptionConfiguration;
import software.amazon.awssdk.services.athena.transform.ResultConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResultConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, ResultConfiguration> {
    private final String outputLocation;
    private final EncryptionConfiguration encryptionConfiguration;

    private ResultConfiguration(BuilderImpl builder) {
        this.outputLocation = builder.outputLocation;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public String outputLocation() {
        return this.outputLocation;
    }

    public EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.outputLocation() == null ? 0 : this.outputLocation().hashCode());
        hashCode = 31 * hashCode + (this.encryptionConfiguration() == null ? 0 : this.encryptionConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultConfiguration)) {
            return false;
        }
        ResultConfiguration other = (ResultConfiguration)obj;
        if (other.outputLocation() == null ^ this.outputLocation() == null) {
            return false;
        }
        if (other.outputLocation() != null && !other.outputLocation().equals(this.outputLocation())) {
            return false;
        }
        if (other.encryptionConfiguration() == null ^ this.encryptionConfiguration() == null) {
            return false;
        }
        return other.encryptionConfiguration() == null || other.encryptionConfiguration().equals(this.encryptionConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.outputLocation() != null) {
            sb.append("OutputLocation: ").append(this.outputLocation()).append(",");
        }
        if (this.encryptionConfiguration() != null) {
            sb.append("EncryptionConfiguration: ").append(this.encryptionConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResultConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String outputLocation;
        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultConfiguration model) {
            this.setOutputLocation(model.outputLocation);
            this.setEncryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getOutputLocation() {
            return this.outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        public final EncryptionConfiguration getEncryptionConfiguration() {
            return this.encryptionConfiguration;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
        }

        public ResultConfiguration build() {
            return new ResultConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResultConfiguration> {
        public Builder outputLocation(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);
    }
}

