/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.athena.model.NamedQuery;
import software.amazon.awssdk.services.athena.model.NamedQueryListCopier;
import software.amazon.awssdk.services.athena.model.UnprocessedNamedQueryId;
import software.amazon.awssdk.services.athena.model.UnprocessedNamedQueryIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetNamedQueryResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchGetNamedQueryResponse> {
    private final List<NamedQuery> namedQueries;
    private final List<UnprocessedNamedQueryId> unprocessedNamedQueryIds;

    private BatchGetNamedQueryResponse(BuilderImpl builder) {
        this.namedQueries = builder.namedQueries;
        this.unprocessedNamedQueryIds = builder.unprocessedNamedQueryIds;
    }

    public List<NamedQuery> namedQueries() {
        return this.namedQueries;
    }

    public List<UnprocessedNamedQueryId> unprocessedNamedQueryIds() {
        return this.unprocessedNamedQueryIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.namedQueries() == null ? 0 : this.namedQueries().hashCode());
        hashCode = 31 * hashCode + (this.unprocessedNamedQueryIds() == null ? 0 : this.unprocessedNamedQueryIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetNamedQueryResponse)) {
            return false;
        }
        BatchGetNamedQueryResponse other = (BatchGetNamedQueryResponse)((Object)obj);
        if (other.namedQueries() == null ^ this.namedQueries() == null) {
            return false;
        }
        if (other.namedQueries() != null && !other.namedQueries().equals(this.namedQueries())) {
            return false;
        }
        if (other.unprocessedNamedQueryIds() == null ^ this.unprocessedNamedQueryIds() == null) {
            return false;
        }
        return other.unprocessedNamedQueryIds() == null || other.unprocessedNamedQueryIds().equals(this.unprocessedNamedQueryIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.namedQueries() != null) {
            sb.append("NamedQueries: ").append(this.namedQueries()).append(",");
        }
        if (this.unprocessedNamedQueryIds() != null) {
            sb.append("UnprocessedNamedQueryIds: ").append(this.unprocessedNamedQueryIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<NamedQuery> namedQueries;
        private List<UnprocessedNamedQueryId> unprocessedNamedQueryIds;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetNamedQueryResponse model) {
            this.setNamedQueries(model.namedQueries);
            this.setUnprocessedNamedQueryIds(model.unprocessedNamedQueryIds);
        }

        public final Collection<NamedQuery> getNamedQueries() {
            return this.namedQueries;
        }

        @Override
        public final Builder namedQueries(Collection<NamedQuery> namedQueries) {
            this.namedQueries = NamedQueryListCopier.copy(namedQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedQueries(NamedQuery ... namedQueries) {
            this.namedQueries(Arrays.asList(namedQueries));
            return this;
        }

        public final void setNamedQueries(Collection<NamedQuery> namedQueries) {
            this.namedQueries = NamedQueryListCopier.copy(namedQueries);
        }

        public final Collection<UnprocessedNamedQueryId> getUnprocessedNamedQueryIds() {
            return this.unprocessedNamedQueryIds;
        }

        @Override
        public final Builder unprocessedNamedQueryIds(Collection<UnprocessedNamedQueryId> unprocessedNamedQueryIds) {
            this.unprocessedNamedQueryIds = UnprocessedNamedQueryIdListCopier.copy(unprocessedNamedQueryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedNamedQueryIds(UnprocessedNamedQueryId ... unprocessedNamedQueryIds) {
            this.unprocessedNamedQueryIds(Arrays.asList(unprocessedNamedQueryIds));
            return this;
        }

        public final void setUnprocessedNamedQueryIds(Collection<UnprocessedNamedQueryId> unprocessedNamedQueryIds) {
            this.unprocessedNamedQueryIds = UnprocessedNamedQueryIdListCopier.copy(unprocessedNamedQueryIds);
        }

        public BatchGetNamedQueryResponse build() {
            return new BatchGetNamedQueryResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetNamedQueryResponse> {
        public Builder namedQueries(Collection<NamedQuery> var1);

        public Builder namedQueries(NamedQuery ... var1);

        public Builder unprocessedNamedQueryIds(Collection<UnprocessedNamedQueryId> var1);

        public Builder unprocessedNamedQueryIds(UnprocessedNamedQueryId ... var1);
    }
}

