/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.transform.UnprocessedQueryExecutionIdMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UnprocessedQueryExecutionId
implements StructuredPojo,
ToCopyableBuilder<Builder, UnprocessedQueryExecutionId> {
    private final String queryExecutionId;
    private final String errorCode;
    private final String errorMessage;

    private UnprocessedQueryExecutionId(BuilderImpl builder) {
        this.queryExecutionId = builder.queryExecutionId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public String queryExecutionId() {
        return this.queryExecutionId;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queryExecutionId() == null ? 0 : this.queryExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.errorCode() == null ? 0 : this.errorCode().hashCode());
        hashCode = 31 * hashCode + (this.errorMessage() == null ? 0 : this.errorMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedQueryExecutionId)) {
            return false;
        }
        UnprocessedQueryExecutionId other = (UnprocessedQueryExecutionId)obj;
        if (other.queryExecutionId() == null ^ this.queryExecutionId() == null) {
            return false;
        }
        if (other.queryExecutionId() != null && !other.queryExecutionId().equals(this.queryExecutionId())) {
            return false;
        }
        if (other.errorCode() == null ^ this.errorCode() == null) {
            return false;
        }
        if (other.errorCode() != null && !other.errorCode().equals(this.errorCode())) {
            return false;
        }
        if (other.errorMessage() == null ^ this.errorMessage() == null) {
            return false;
        }
        return other.errorMessage() == null || other.errorMessage().equals(this.errorMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queryExecutionId() != null) {
            sb.append("QueryExecutionId: ").append(this.queryExecutionId()).append(",");
        }
        if (this.errorCode() != null) {
            sb.append("ErrorCode: ").append(this.errorCode()).append(",");
        }
        if (this.errorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.errorMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UnprocessedQueryExecutionIdMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String queryExecutionId;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedQueryExecutionId model) {
            this.setQueryExecutionId(model.queryExecutionId);
            this.setErrorCode(model.errorCode);
            this.setErrorMessage(model.errorMessage);
        }

        public final String getQueryExecutionId() {
            return this.queryExecutionId;
        }

        @Override
        public final Builder queryExecutionId(String queryExecutionId) {
            this.queryExecutionId = queryExecutionId;
            return this;
        }

        public final void setQueryExecutionId(String queryExecutionId) {
            this.queryExecutionId = queryExecutionId;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public UnprocessedQueryExecutionId build() {
            return new UnprocessedQueryExecutionId(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UnprocessedQueryExecutionId> {
        public Builder queryExecutionId(String var1);

        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);
    }
}

