/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.athena.model.Datum;

public class DatumUnmarshaller
implements Unmarshaller<Datum, JsonUnmarshallerContext> {
    private static final DatumUnmarshaller INSTANCE = new DatumUnmarshaller();

    public Datum unmarshall(JsonUnmarshallerContext context) throws Exception {
        Datum.Builder datumBuilder = Datum.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("VarCharValue", targetDepth)) {
                    context.nextToken();
                    datumBuilder.varCharValue((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Datum)datumBuilder.build();
    }

    public static DatumUnmarshaller getInstance() {
        return INSTANCE;
    }
}

