/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.ColumnInfo;
import software.amazon.awssdk.services.athena.model.ColumnInfoListCopier;
import software.amazon.awssdk.services.athena.transform.ResultSetMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultSetMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, ResultSetMetadata> {
    private final List<ColumnInfo> columnInfo;

    private ResultSetMetadata(BuilderImpl builder) {
        this.columnInfo = builder.columnInfo;
    }

    public List<ColumnInfo> columnInfo() {
        return this.columnInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSetMetadata)) {
            return false;
        }
        ResultSetMetadata other = (ResultSetMetadata)obj;
        return Objects.equals(this.columnInfo(), other.columnInfo());
    }

    public String toString() {
        return ToString.builder((String)"ResultSetMetadata").add("ColumnInfo", this.columnInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnInfo": {
                return Optional.ofNullable(clazz.cast(this.columnInfo()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResultSetMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ColumnInfo> columnInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResultSetMetadata model) {
            this.columnInfo(model.columnInfo);
        }

        public final Collection<ColumnInfo.Builder> getColumnInfo() {
            return this.columnInfo != null ? (Collection)this.columnInfo.stream().map(ColumnInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder columnInfo(Collection<ColumnInfo> columnInfo) {
            this.columnInfo = ColumnInfoListCopier.copy(columnInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnInfo(ColumnInfo ... columnInfo) {
            this.columnInfo(Arrays.asList(columnInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnInfo(Consumer<ColumnInfo.Builder> ... columnInfo) {
            this.columnInfo(Stream.of(columnInfo).map(c -> (ColumnInfo)((ColumnInfo.Builder)ColumnInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setColumnInfo(Collection<ColumnInfo.BuilderImpl> columnInfo) {
            this.columnInfo = ColumnInfoListCopier.copyFromBuilder(columnInfo);
        }

        public ResultSetMetadata build() {
            return new ResultSetMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResultSetMetadata> {
        public Builder columnInfo(Collection<ColumnInfo> var1);

        public Builder columnInfo(ColumnInfo ... var1);

        public Builder columnInfo(Consumer<ColumnInfo.Builder> ... var1);
    }
}

