/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse;

public class ListQueryExecutionsIterable
implements SdkIterable<ListQueryExecutionsResponse> {
    private final AthenaClient client;
    private final ListQueryExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQueryExecutionsIterable(AthenaClient client, ListQueryExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListQueryExecutionsResponseFetcher();
    }

    public Iterator<ListQueryExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListQueryExecutionsIterable resume(ListQueryExecutionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListQueryExecutionsIterable(this.client, (ListQueryExecutionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListQueryExecutionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListQueryExecutionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListQueryExecutionsResponseFetcher
    implements SyncPageFetcher<ListQueryExecutionsResponse> {
        private ListQueryExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListQueryExecutionsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListQueryExecutionsResponse nextPage(ListQueryExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListQueryExecutionsIterable.this.client.listQueryExecutions(ListQueryExecutionsIterable.this.firstRequest);
            }
            return ListQueryExecutionsIterable.this.client.listQueryExecutions((ListQueryExecutionsRequest)((Object)ListQueryExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

